<?php
defined( 'ABSPATH' ) || exit;

/**
 * Form Field Actions.
 * 
 * @class QTS_Meta_Box_Form_Field_Actions
 * @package Class
 */
class QTS_Meta_Box_Form_Field_Actions {

	/**
	 * Output the metabox.
	 *
	 * @param WP_Post $post Post object.
	 */
	public static function output( $post ) {
		global $post;

		$field_key                  = QTS_Form_Fields::get_prop( $post->ID, 'name' );
		$is_default_field           = QTS_Form_Fields::is_default_field( $post->ID );
		$is_default_email_field     = $is_default_field && 'billing_email' === $field_key;
		$is_default_firstname_field = $is_default_field && 'billing_first_name' === $field_key;
		?>
		<ul class="order_actions submitbox">
			<?php
			/**
			 * Trigger after form field actions start.
			 * 
			 * @param int $post_id
			 * @since 1.0
			 */
			do_action( 'qts_form_field_actions_start', $post->ID );
			?>

			<li class="wide">
				<label for="_field_status"><?php esc_html_e( 'Status', 'quote-request-for-woocommerce' ); ?></label><br>
				<select name="_field_status" <?php disabled( $is_default_email_field || $is_default_firstname_field, true, true ); ?>>
					<optgroup label="<?php esc_html_e( 'Choose a status...', 'quote-request-for-woocommerce' ); ?>">
						<?php foreach ( _qts_get_form_field_statuses() as $status_name => $status_label ) { ?>
							<option value="<?php echo esc_attr( $status_name ); ?>" <?php selected( QTS_Form_Fields::get_prop( $post->ID, 'status', true ), $status_name, true ); ?>><?php echo esc_html( $status_label ); ?></option>
						<?php } ?>
					</optgroup>
				</select>
			</li>

			<li class="wide">
				<label for="_field_required"><?php esc_html_e( 'Required?', 'quote-request-for-woocommerce' ); ?></label><br>
				<input type="checkbox" name="_field_required" value="1" <?php disabled( $is_default_email_field || $is_default_firstname_field, true, true ); ?> <?php checked( QTS_Form_Fields::get_prop( $post->ID, 'required', true ), '1', true ); ?>>
			</li>

			<li class="wide">
				<?php if ( ! $is_default_field ) { ?>
					<div id="delete-action">
						<?php
						if ( current_user_can( 'delete_post', $post->ID ) ) {
							if ( ! EMPTY_TRASH_DAYS ) {
								$delete_text = __( 'Delete permanently', 'quote-request-for-woocommerce' );
							} else {
								$delete_text = __( 'Move to Trash', 'quote-request-for-woocommerce' );
							}
							?>
							<a class="submitdelete deletion" href="<?php echo esc_url( get_delete_post_link( $post->ID ) ); ?>"><?php echo esc_html( $delete_text ); ?></a>
							<?php
						}
						?>
					</div>
				<?php } ?>
				<button type="submit" class="button save_order button-primary" name="save" value="<?php echo 'auto-draft' === $post->post_status ? esc_attr__( 'Create', 'quote-request-for-woocommerce' ) : esc_attr__( 'Update', 'quote-request-for-woocommerce' ); ?>"><?php echo 'auto-draft' === $post->post_status ? esc_html__( 'Create', 'quote-request-for-woocommerce' ) : esc_html__( 'Update', 'quote-request-for-woocommerce' ); ?></button>
			</li>

			<?php
			/**
			 * Trigger after form field actions end.
			 * 
			 * @param int $post_id
			 * @since 1.0
			 */
			do_action( 'qts_form_field_actions_end', $post->ID );
			?>
		</ul>
		<?php
	}

	/**
	 * Save meta box data.
	 *
	 * @param int $post_id
	 * @param WP_Post $post
	 */
	public static function save( $post_id, $post, $posted ) {
		if ( '' === get_post_meta( $post_id, '_name', true ) ) {
			update_post_meta( $post_id, '_name', QTS_Form_Fields::prepare_name( $post_id ) );
		}

		$field_key                  = QTS_Form_Fields::get_prop( $post_id, 'name' );
		$is_default_field           = QTS_Form_Fields::is_default_field( $post_id );
		$is_default_email_field     = $is_default_field && 'billing_email' === $field_key;
		$is_default_firstname_field = $is_default_field && 'billing_first_name' === $field_key;

		if ( ! $is_default_field ) {
			update_post_meta( $post_id, '_default', wc_clean( wp_unslash( $posted[ '_field_default' ] ) ) );
		}

		if ( ! $is_default_email_field && ! $is_default_firstname_field ) {
			update_post_meta( $post_id, '_required', ! empty( $posted[ '_field_required' ] ) ? '1' : ''  );
		}

		update_post_meta( $post_id, '_placeholder', wc_clean( wp_unslash( $posted[ '_field_placeholder' ] ) ) );

		$options = array();
		if ( ! empty( $posted[ '_field_option_key' ] ) ) {
			foreach ( $posted[ '_field_option_key' ] as $row_key => $option_key ) {
				if ( ! isset( $posted[ '_field_option_value' ][ $row_key ] ) ) {
					continue;
				}

				$option_value = wc_clean( wp_unslash( $posted[ '_field_option_value' ][ $row_key ] ) );

				if ( '' !== $option_value ) {
					$options[ $option_key ] = $option_value;
				}
			}
		}

		update_post_meta( $post_id, '_options', $options );

		$posted_data = array();

		if ( isset( $posted[ '_field_status' ] ) ) {
			$posted_data[ 'post_status' ] = wc_clean( wp_unslash( $posted[ '_field_status' ] ) );
		}

		if ( isset( $posted[ '_field_type' ] ) ) {
			$posted_data[ 'post_excerpt' ] = sanitize_title( wp_unslash( $posted[ '_field_type' ] ) );
		}

		if ( isset( $posted[ '_field_description' ] ) ) {
			$posted_data[ 'post_content' ] = sanitize_textarea_field( wp_unslash( $posted[ '_field_description' ] ) );
		}

		if ( $is_default_field ) {
			unset( $posted_data[ 'post_excerpt' ] );
		}

		if ( $is_default_email_field || $is_default_firstname_field ) {
			unset( $posted_data[ 'post_status' ] );
		}

		if ( doing_action( 'save_post' ) ) {
			$GLOBALS[ 'wpdb' ]->update( $GLOBALS[ 'wpdb' ]->posts, $posted_data, array( 'ID' => $post_id ) );
			clean_post_cache( $post_id );
		} else {
			wp_update_post( array_merge( array( 'ID' => $post_id ), $posted_data ) );
		}
	}
}
