<?php
/**
 * Quote Request conversations notes HTML for meta box.
 */
defined( 'ABSPATH' ) || exit;
?>
<ul class="quote_request_conversation_notes">
	<?php
	if ( $notes ) {
		foreach ( $notes as $note ) {
			$css_class   = array( 'note' );
			$css_class[] = 'admin' === $note->added_by ? 'qts-note-to-customer' : 'qts-note-to-admin';

			/**
			 * Get quote request conversation note class.
			 * 
			 * @since 1.0
			 */
			$css_class = apply_filters( 'qts_quote_request_conversation_note_class', array_filter( $css_class ), $note );
			?>
			<li rel="<?php echo absint( $note->id ); ?>" class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<div class="note_content">
					<?php echo wp_kses_post( wpautop( wptexturize( $note->content ) ) ); ?>
				</div>
				<p class="meta">
					<abbr class="exact-date" title="<?php echo esc_attr( $note->date_created->date( 'Y-m-d H:i:s' ) ); ?>">
						<?php
						/* translators: %1$s: note date %2$s: note time */
						echo esc_html( sprintf( __( '%1$s at %2$s', 'quote-request-for-woocommerce' ), $note->date_created->date_i18n( wc_date_format() ), $note->date_created->date_i18n( wc_time_format() ) ) );
						?>
					</abbr>
					<?php
					if ( 'system' !== $note->added_by ) :
						/* translators: %s: note author */
						echo esc_html( sprintf( ' ' . __( 'by %s', 'quote-request-for-woocommerce' ), $note->added_user ) );
					endif;
					?>
					<a href="#" class="delete_note" role="button"><?php esc_html_e( 'Delete note', 'quote-request-for-woocommerce' ); ?></a>
				</p>
			</li>
			<?php
		}
	} else {
		?>
		<li><?php esc_html_e( 'There are no notes yet.', 'quote-request-for-woocommerce' ); ?></li>
		<?php
	}
	?>
</ul>
