<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

include_once 'class-qts-store-api.php';

/**
 * Blocks Compatibility.
 *
 * @since 3.0.0
 * @class QTS_Blocks_Compatibility
 * @package Class
 */
class QTS_Blocks_Compatibility {

	/**
	 * Min required plugin versions to check.
	 *
	 * @since 3.0.0
	 * @var array
	 */
	private static $required = array(
		'blocks' => '7.0.0',
	);

	/**
	 * Initialize.
	 * 
	 * @since 3.0.0
	 */
	public static function init() {
		// When WooCommerce Blocks is loaded, set up the Integration class.
		add_action( 'woocommerce_blocks_loaded', __CLASS__ . '::setup_blocks_integration' );
		add_action( 'woocommerce_blocks_loaded', 'QTS_Store_API::init' );       
	}

	/**
	 * Sets up the Blocks integration class.
	 * 
	 * @since 3.0.0
	 */
	public static function setup_blocks_integration() {
		if ( ! class_exists( '\Automattic\WooCommerce\Blocks\Package' ) || version_compare( \Automattic\WooCommerce\Blocks\Package::get_version(), self::$required[ 'blocks' ] ) <= 0 ) {
			return;
		}

		/**
		 * Filter the compatible blocks.
		 * 
		 * @since 3.0.0
		 */
		$compatible_blocks = apply_filters( 'qts_compatible_blocks', array( 'cart', 'checkout', 'mini-cart' ) );
		foreach ( $compatible_blocks as $block_name ) {
			add_action(
					"woocommerce_blocks_{$block_name}_block_registration",
					function ( $registry ) {
						include_once 'class-qts-blocks-integration.php';
						$registry->register( QTS_Blocks_Integration::instance() );
					}
			);
		}
	}
}

QTS_Blocks_Compatibility::init();
