<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'QTS_Email_Admin_Response_Awaited', false ) ) {

	/**
	 * Response Awaited Email to Admin.
	 * 
	 * An email will be sent to the admin to response when the customer is replied.
	 * 
	 * @class QTS_Email_Admin_Response_Awaited
	 * @package class
	 * @extends QTS_Abstract_Email
	 */
	class QTS_Email_Admin_Response_Awaited extends QTS_Abstract_Email {

		/**
		 * Gets the user object.
		 * 
		 * @var WP_User
		 */
		public $user;

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->id          = QTS_PREFIX . 'admin_response_awaited';
			$this->title       = __( 'Response Awaited from Admin', 'quote-request-for-woocommerce' );
			$this->description = __( 'Response Awaited from Admin emails are sent to the admin to response when the customer is replied.', 'quote-request-for-woocommerce' );

			$this->template_html  = 'emails/admin-response-awaited.php';
			$this->template_plain = 'emails/plain/admin-response-awaited.php';

			$this->subject = __( '[{site_title}] - Quote Response Awaited', 'quote-request-for-woocommerce' );
			$this->heading = __( 'Quote Response Awaited', 'quote-request-for-woocommerce' );

			// Triggers for this email.
			add_action( 'qts_quote_request_new_customer_note_added_by_customer_notification', array( $this, 'trigger' ), 10, 3 );

			// Other settings.
			$this->supports = array( 'recipient' );

			// Call parent constructor
			parent::__construct();
		}

		/**
		 * Get content args.
		 *
		 * @return array
		 */
		public function get_content_args() {
			$content_args                    = parent::get_content_args();
			$content_args[ 'sent_to_admin' ] = true;
			$content_args[ 'quote_request' ] = $this->object;
			$content_args[ 'user_nicename' ] = stripslashes( $this->user->user_nicename );
			$content_args[ 'user_login' ]    = stripslashes( $this->user->user_login );

			return $content_args;
		}

		/**
		 * Trigger the sending of this email.
		 *
		 * @param QTS_Quote_Request $quote_request
		 */
		public function trigger( $note_id, $note_content, $quote_request ) {
			if ( ! is_object( $quote_request ) ) {
				$quote_request_id = absint( $quote_request );
				$quote_request    = _qts_get_quote_request( $quote_request_id );
			}

			$this->object = $quote_request;
			$this->user   = new WP_User( $quote_request->get_user_id() );

			$this->maybe_trigger();
		}
	}

}

return new QTS_Email_Admin_Response_Awaited();
