<?php
/**
 * Add to Quote
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/add-to-quote.php.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="qts-add-to-quote">
	<?php
	if ( $show_user_options ) {
		?>
		<p class="qts-add-to-quote-mode-selection">
			<label for="add_to_qtsquote_mode"><?php echo esc_html( get_option( QTS_PREFIX . 'quote_mode_selection_label' ) ); ?></label>
			<select id="add_to_qtsquote_mode" name="add-to-qtsquote-mode" data-product_id="<?php echo esc_attr( $product->get_id() ); ?>">
				<option><?php esc_html_e( 'Select Option', 'quote-request-for-woocommerce' ); ?></option>
				<option value="approx" <?php selected( $chosen_mode, 'approx' ); ?>><?php esc_html_e( 'Approximate Quote(Excluding Shipping and Other Costs)', 'quote-request-for-woocommerce' ); ?></option>
				<option value="accurate" <?php selected( $chosen_mode, 'accurate' ); ?>><?php esc_html_e( 'Accurate Quote(Final Amount to be Paid)', 'quote-request-for-woocommerce' ); ?></option>
			</select>
		</p>
		<?php
	}

	/**
	 * Before add to quote button.
	 * 
	 * @since 1.0
	 */
	do_action( 'qts_before_add_to_quote_button' );
	?>
	<a href="<?php echo esc_url( $add_to_quote_url ); ?>" 
	   class="<?php echo esc_attr( $class_name ); ?>" 
	   data-product_id="<?php echo esc_attr( $product->get_id() ); ?>"
	   >
		   <?php echo esc_html( $add_to_quote_label ); ?>
	</a>
	<?php
	/**
	 * After add to quote button.
	 * 
	 * @since 1.0
	 */
	do_action( 'qts_after_add_to_quote_button' );
	?>
</div>
