<?php
/**
 * Quote mode selection.
 *
 * @since 3.0.0
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/quote-mode-selection.php.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Before mode selection.
 *
 * @since 3.0.0
 */
do_action( 'qts_before_mode_selection' );

$quote_mode = get_option( QTS_PREFIX . 'quote_request_mode' );
?>
<p id="qts_convert_to_quote_mode_selection_wrapper" style="display: none;">
	<label for="qts_convert_to_quote_mode_selection"><?php echo esc_html( get_option( QTS_PREFIX . 'quote_mode_selection_label' ) ); ?></label>
	<select id="qts_convert_to_quote_mode_selection">
		<option><?php esc_html_e( 'Select Option', 'quote-request-for-woocommerce' ); ?></option>
		<option value="approx" <?php selected( $quote_mode, 'approx' ); ?>><?php esc_html_e( 'Approximate Quote(Excluding Shipping and Other Costs)', 'quote-request-for-woocommerce' ); ?></option>
		<option value="accurate" <?php selected( $quote_mode, 'accurate' ); ?>><?php esc_html_e( 'Accurate Quote(Final Amount to be Paid)', 'quote-request-for-woocommerce' ); ?></option>
	</select>
</p>
<?php
/**
 * After mode selection.
 *
 * @since 3.0.0
 */
do_action( 'qts_after_mode_selection' );
?>

