<?php
/**
 * Quote Request Conversation Notes.
 * Shows the details of a particular quote request conversation on the account page.
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/myaccount/quote-request-conversation-notes.php.
 */
defined( 'ABSPATH' ) || exit ;
?>

<?php
if ( $notes ) {
	foreach ( $notes as $note ) {
		$css_class   = array( 'qts-customer-note' ) ;
		$css_class[] = 'customer' === $note->added_by ? 'qts-customer-added-note' : 'qts-admin-added-note' ;
		?>
		<li rel="<?php echo absint( $note->id ) ; ?>" class="<?php echo esc_attr( implode( ' ', $css_class ) ) ; ?>">
			<div class="qts-note-content">
				<?php echo wp_kses_post( wpautop( wptexturize( $note->content ) ) ) ; ?>
			</div>
			<p class="qts-note-meta">
				<abbr class="qts-note-added-date" title="<?php echo esc_attr( $note->date_created->date( 'Y-m-d H:i:s' ) ) ; ?>">
					<?php
					/* translators: %1$s: note date %2$s: note time */
					echo esc_html( sprintf( __( '%1$s at %2$s', 'quote-request-for-woocommerce' ), $note->date_created->date_i18n( wc_date_format() ), $note->date_created->date_i18n( wc_time_format() ) ) ) ;
					?>
				</abbr>
				<?php
				/* translators: %s: note author */
				echo wp_kses_post( sprintf( ' ' . __( 'by <b>%s</b>', 'quote-request-for-woocommerce' ), $note->added_user ) ) ;
				?>
			</p>
		</li>
		<?php
	}
} else {
	?>
	<li><?php esc_html_e( 'There are no conversations yet.', 'quote-request-for-woocommerce' ) ; ?></li>
	<?php
}
?>
