(() => {
	'use strict';

	var external_plugins = window["wp"]["plugins"];
	var external_element = window["wp"]["element"];
	var external_blocks = window["wp"]["blocks"];
	var external_blockEditor = window["wp"]["blockEditor"];
	var external_i18n = window["wp"]["i18n"];
	var external_data = window["wp"]["data"];
	var external_compose = window["wp"]["compose"];
	var external_components = window["wp"]["components"];
	var external_primitives = window["wp"]["primitives"];	
	var external_wc_blocksCheckout = window["wc"]["blocksCheckout"];
	var external_wc_priceFormat = window["wc"]["priceFormat"];
	var external_wc_settings = window["wc"]["wcSettings"];
	
	var callBack = {
		ourData: null,
		isOurs: function (e) {
			// Bail out early.         
			if (undefined === e['quote-request-for-woocommerce']) {
				return false;
			}
			
			callBack.ourData = e['quote-request-for-woocommerce'];
			return true;
		},
		cartBlocks: {
			init: function (e) {
				if( callBack.isOurs(e.extensions) ){
					if( callBack.ourData.convert_to_quote_enabled ){
						return external_element.createElement(callBack.cartBlocks.converttoQuote.init, e);
					} else if( callBack.ourData.back_to_cart_enabled ){
						return external_element.createElement(callBack.cartBlocks.backtoCart.init, e);
					}
				}

				return null;
			},
			converttoQuote: {
				cartSchema: JSON.parse("{\"name\":\"woocommerce/cart-order-summary-qts-convert-to-quote-block\",\"icon\":\"welcome-write-blog\",\"keywords\":[\"convert\" , \"quote\"],\"version\":\"1.0.0\",\"title\":\"Convert to Quote\",\"description\":\"Shows the Convert to Quote Button.\",\"category\":\"woocommerce\",\"supports\":{\"align\":false,\"html\":false,\"multiple\":false,\"reusable\":false},\"attributes\":{\"className\":{\"type\":\"string\",\"default\":\"\"},\"lock\":{\"type\":\"object\",\"default\":{\"remove\":true,\"move\":false}}},\"parent\":[\"woocommerce/cart-totals-block\"],\"textdomain\":\"quote-request-for-woocommerce\",\"apiVersion\":2}"),
				checkoutSchema: JSON.parse("{\"name\":\"woocommerce/checkout-order-summary-qts-convert-to-quote-block\",\"icon\":\"welcome-write-blog\",\"keywords\":[\"convert\" ,\"quote\"],\"version\":\"1.0.0\",\"title\":\"Convert to Quote\",\"description\":\"Shows the Convert to Quote Button.\",\"category\":\"woocommerce\",\"supports\":{\"align\":false,\"html\":false,\"multiple\":false,\"reusable\":false},\"attributes\":{\"className\":{\"type\":\"string\",\"default\":\"\"},\"lock\":{\"type\":\"object\",\"default\":{\"remove\":true,\"move\":false}}},\"parent\":[\"woocommerce/checkout-totals-block\"],\"textdomain\":\"quote-request-for-woocommerce\",\"apiVersion\":2}"),
				init: function () {
					return external_element.createElement(external_wc_blocksCheckout.TotalsWrapper, { className: "qts-convert-to-quote-wrapper" },
						external_element.createElement(callBack.cartBlocks.converttoQuote.submit));
				},
				edit: function (e) {
					return external_element.createElement("div", external_blockEditor.useBlockProps(),
						external_element.createElement(callBack.cartBlocks.converttoQuote.submit));
				},
				save: function (e) {
					return external_element.createElement("div", external_blockEditor.useBlockProps.save());
				},
				submit: function (e) {
					return external_element.createElement(external_wc_blocksCheckout.TotalsWrapper, {},
						external_element.createElement(external_wc_blocksCheckout.Panel, { className: 'qts-convert-to-quote__panel', title: external_i18n.__("Convert to Quote", 'quote-request-for-woocommerce') }));
				}
			},
			backtoCart: {
				cartSchema: JSON.parse("{\"name\":\"woocommerce/cart-order-summary-qts-back-to-cart-block\",\"icon\":\"controls-back\",\"keywords\":[\"back\" , \"cart\"],\"version\":\"1.0.0\",\"title\":\"Back to Cart\",\"description\":\"Shows the Back to Cart Button.\",\"category\":\"woocommerce\",\"supports\":{\"align\":false,\"html\":false,\"multiple\":false,\"reusable\":false},\"attributes\":{\"className\":{\"type\":\"string\",\"default\":\"\"},\"lock\":{\"type\":\"object\",\"default\":{\"remove\":true,\"move\":false}}},\"parent\":[\"woocommerce/cart-totals-block\"],\"textdomain\":\"quote-request-for-woocommerce\",\"apiVersion\":2}"),
				checkoutSchema: JSON.parse("{\"name\":\"woocommerce/checkout-order-summary-qts-back-to-cart-block\",\"icon\":\"controls-back\",\"keywords\":[\"back\" , \"cart\"],\"version\":\"1.0.0\",\"title\":\"Back to Cart\",\"description\":\"Shows the Back to Cart Button.\",\"category\":\"woocommerce\",\"supports\":{\"align\":false,\"html\":false,\"multiple\":false,\"reusable\":false},\"attributes\":{\"className\":{\"type\":\"string\",\"default\":\"\"},\"lock\":{\"type\":\"object\",\"default\":{\"remove\":true,\"move\":false}}},\"parent\":[\"woocommerce/checkout-totals-block\"],\"textdomain\":\"quote-request-for-woocommerce\",\"apiVersion\":2}"),
				init: function () {
					return external_element.createElement(external_wc_blocksCheckout.TotalsWrapper, { className: "qts-back-to-cart-wrapper" },
						external_element.createElement(callBack.cartBlocks.backtoCart.undo));
				},
				edit: function (e) {
					return external_element.createElement("div", external_blockEditor.useBlockProps(),
						external_element.createElement(callBack.cartBlocks.backtoCart.undo));
				},
				save: function (e) {
					return external_element.createElement("div", external_blockEditor.useBlockProps.save());
				},
				undo: function (e) {
					return external_element.createElement(external_wc_blocksCheckout.TotalsWrapper, {},
						external_element.createElement(external_wc_blocksCheckout.Panel, { className: 'qts-back-to-cart__panel', title: external_i18n.__("Back to Cart", 'quote-request-for-woocommerce') }));
				}
			}
		},
	};

	// Register Block in the Editor.
	external_blocks.registerBlockType(callBack.cartBlocks.converttoQuote.cartSchema.name, {
		title: callBack.cartBlocks.converttoQuote.cartSchema.title, // Localize title using wp.i18n.__()
		version: callBack.cartBlocks.converttoQuote.cartSchema.version,
		description: callBack.cartBlocks.converttoQuote.cartSchema.description,
		category: callBack.cartBlocks.converttoQuote.cartSchema.category, // Category Options: common, formatting, layout, widgets, embed
		supports: callBack.cartBlocks.converttoQuote.cartSchema.supports,
		icon: callBack.cartBlocks.converttoQuote.cartSchema.icon, // Dashicons Options – https://goo.gl/aTM1DQ
		keywords: callBack.cartBlocks.converttoQuote.cartSchema.keywords, // Limit to 3 Keywords / Phrases
		parent: callBack.cartBlocks.converttoQuote.cartSchema.parent,
		textdomain: callBack.cartBlocks.converttoQuote.cartSchema.textdomain,
		apiVersion: callBack.cartBlocks.converttoQuote.cartSchema.apiVersion,
		attributes: callBack.cartBlocks.converttoQuote.cartSchema.attributes, // Attributes set for each piece of dynamic data used in your block
		edit: callBack.cartBlocks.converttoQuote.edit, // Determines what is displayed in the editor
		save: callBack.cartBlocks.converttoQuote.save // Determines what is displayed on the frontend
	});

	external_blocks.registerBlockType(callBack.cartBlocks.converttoQuote.checkoutSchema.name, {
		title: callBack.cartBlocks.converttoQuote.checkoutSchema.title, // Localize title using wp.i18n.__()
		version: callBack.cartBlocks.converttoQuote.checkoutSchema.version,
		description: callBack.cartBlocks.converttoQuote.checkoutSchema.description,
		category: callBack.cartBlocks.converttoQuote.checkoutSchema.category, // Category Options: common, formatting, layout, widgets, embed
		supports: callBack.cartBlocks.converttoQuote.checkoutSchema.supports,
		icon: callBack.cartBlocks.converttoQuote.checkoutSchema.icon, // Dashicons Options – https://goo.gl/aTM1DQ
		keywords: callBack.cartBlocks.converttoQuote.checkoutSchema.keywords, // Limit to 3 Keywords / Phrases
		parent: callBack.cartBlocks.converttoQuote.checkoutSchema.parent,
		textdomain: callBack.cartBlocks.converttoQuote.checkoutSchema.textdomain,
		apiVersion: callBack.cartBlocks.converttoQuote.checkoutSchema.apiVersion,
		attributes: callBack.cartBlocks.converttoQuote.checkoutSchema.attributes, // Attributes set for each piece of dynamic data used in your block
		edit: callBack.cartBlocks.converttoQuote.edit, // Determines what is displayed in the editor
		save: callBack.cartBlocks.converttoQuote.save // Determines what is displayed on the frontend
	});

	// Register Block in the Editor.
	external_blocks.registerBlockType(callBack.cartBlocks.backtoCart.cartSchema.name, {
		title: callBack.cartBlocks.backtoCart.cartSchema.title, // Localize title using wp.i18n.__()
		version: callBack.cartBlocks.backtoCart.cartSchema.version,
		description: callBack.cartBlocks.backtoCart.cartSchema.description,
		category: callBack.cartBlocks.backtoCart.cartSchema.category, // Category Options: common, formatting, layout, widgets, embed
		supports: callBack.cartBlocks.backtoCart.cartSchema.supports,
		icon: callBack.cartBlocks.backtoCart.cartSchema.icon, // Dashicons Options – https://goo.gl/aTM1DQ
		keywords: callBack.cartBlocks.backtoCart.cartSchema.keywords, // Limit to 3 Keywords / Phrases
		parent: callBack.cartBlocks.backtoCart.cartSchema.parent,
		textdomain: callBack.cartBlocks.backtoCart.cartSchema.textdomain,
		apiVersion: callBack.cartBlocks.backtoCart.cartSchema.apiVersion,
		attributes: callBack.cartBlocks.backtoCart.cartSchema.attributes, // Attributes set for each piece of dynamic data used in your block
		edit: callBack.cartBlocks.backtoCart.edit, // Determines what is displayed in the editor
		save: callBack.cartBlocks.backtoCart.save // Determines what is displayed on the frontend
	});

	external_blocks.registerBlockType(callBack.cartBlocks.backtoCart.checkoutSchema.name, {
		title: callBack.cartBlocks.backtoCart.checkoutSchema.title, // Localize title using wp.i18n.__()
		version: callBack.cartBlocks.backtoCart.checkoutSchema.version,
		description: callBack.cartBlocks.backtoCart.checkoutSchema.description,
		category: callBack.cartBlocks.backtoCart.checkoutSchema.category, // Category Options: common, formatting, layout, widgets, embed
		supports: callBack.cartBlocks.backtoCart.checkoutSchema.supports,
		icon: callBack.cartBlocks.backtoCart.checkoutSchema.icon, // Dashicons Options – https://goo.gl/aTM1DQ
		keywords: callBack.cartBlocks.backtoCart.checkoutSchema.keywords, // Limit to 3 Keywords / Phrases
		parent: callBack.cartBlocks.backtoCart.checkoutSchema.parent,
		textdomain: callBack.cartBlocks.backtoCart.checkoutSchema.textdomain,
		apiVersion: callBack.cartBlocks.backtoCart.checkoutSchema.apiVersion,
		attributes: callBack.cartBlocks.backtoCart.checkoutSchema.attributes, // Attributes set for each piece of dynamic data used in your block
		edit: callBack.cartBlocks.backtoCart.edit, // Determines what is displayed in the editor
		save: callBack.cartBlocks.backtoCart.save // Determines what is displayed on the frontend
	});
})();
