<?php

defined( 'ABSPATH' ) || exit ;

/**
 * Quote Request Data.
 * 
 * @class QTS_Meta_Box_Quote_Request_Data
 * @package Class
 */
class QTS_Meta_Box_Quote_Request_Data extends WC_Meta_Box_Order_Data {

	/**
	 * Output the metabox.
	 *
	 * @param WP_Post $post
	 */
	public static function output( $post ) {
		global $post, $thequote_request ;

		if ( ! is_object( $thequote_request ) ) {
			$thequote_request = _qts_get_quote_request( $post->ID ) ;
		}

		$quote_request      = $thequote_request ;
		$quote_request_post = $post ;

		self::init_address_fields() ;

		if ( WC()->payment_gateways() ) {
			$payment_gateways = WC()->payment_gateways->payment_gateways() ;
		} else {
			$payment_gateways = array() ;
		}

		$payment_method  = $quote_request->get_payment_method() ;
		$billing_fields  = self::$billing_fields ;
		$shipping_fields = self::$shipping_fields ;

		include 'views/html-quote-request-data.php' ;
	}

	/**
	 * Save meta box data.
	 *
	 * @param int $post_id
	 * @param WP_Post $post
	 */
	public static function save( $post_id, $post = null ) {
		if ( 'qts_quote_request' !== $post->post_type || empty( $_POST[ 'woocommerce_meta_nonce' ] ) || ! wp_verify_nonce( sanitize_key( $_POST[ 'woocommerce_meta_nonce' ] ), 'woocommerce_save_data' ) ) {
			return ;
		}

		self::init_address_fields() ;

		// Get quote request object.
		$quote_request = _qts_get_quote_request( $post_id ) ;
		$props         = array() ;

		// Create quote request key.
		if ( ! $quote_request->get_order_key() ) {
			$props[ 'order_key' ] = _qts_generate_key() ;
		}

		// Update customer.
		$customer_id = isset( $_POST[ 'customer_user' ] ) ? absint( wp_unslash( $_POST[ 'customer_user' ] ) ) : 0 ;
		if ( $customer_id !== $quote_request->get_customer_id() ) {
			$props[ 'customer_id' ] = $customer_id ;
		}

		// Update billing fields.
		if ( ! empty( self::$billing_fields ) ) {
			foreach ( self::$billing_fields as $key => $field ) {
				if ( ! isset( $field[ 'id' ] ) ) {
					$field[ 'id' ] = '_billing_' . $key ;
				}

				if ( ! isset( $_POST[ $field[ 'id' ] ] ) ) {
					continue ;
				}

				if ( is_callable( array( $quote_request, 'set_billing_' . $key ) ) ) {
					$props[ 'billing_' . $key ] = wc_clean( wp_unslash( $_POST[ $field[ 'id' ] ] ) ) ;
				} else {
					$quote_request->update_meta_data( $field[ 'id' ], wc_clean( wp_unslash( $_POST[ $field[ 'id' ] ] ) ) ) ;
				}
			}
		}

		// Update shipping fields.
		if ( ! empty( self::$shipping_fields ) ) {
			foreach ( self::$shipping_fields as $key => $field ) {
				if ( ! isset( $field[ 'id' ] ) ) {
					$field[ 'id' ] = '_shipping_' . $key ;
				}

				if ( ! isset( $_POST[ $field[ 'id' ] ] ) ) {
					continue ;
				}

				if ( is_callable( array( $quote_request, 'set_shipping_' . $key ) ) ) {
					$props[ 'shipping_' . $key ] = wc_clean( wp_unslash( $_POST[ $field[ 'id' ] ] ) ) ;
				} else {
					$quote_request->update_meta_data( $field[ 'id' ], wc_clean( wp_unslash( $_POST[ $field[ 'id' ] ] ) ) ) ;
				}
			}
		}

		// Update date.
		if ( empty( $_POST[ 'order_date' ] ) ) {
			$props[ 'date_created' ] = time() ;
		} else {
			if ( isset( $_POST[ 'order_date' ], $_POST[ 'order_date_hour' ], $_POST[ 'order_date_minute' ], $_POST[ 'order_date_second' ] ) ) {
				$props[ 'date_created' ] = gmdate( 'Y-m-d H:i:s', strtotime( wc_clean( wp_unslash( $_POST[ 'order_date' ] ) ) . ' ' . ( int ) wc_clean( wp_unslash( $_POST[ 'order_date_hour' ] ) ) . ':' . ( int ) wc_clean( wp_unslash( $_POST[ 'order_date_minute' ] ) ) . ':' . ( int ) wc_clean( wp_unslash( $_POST[ 'order_date_second' ] ) ) ) ) ;
			}
		}

		// Update expiry date.
		$expiry_date_updated = false ;
		if ( isset( $_POST[ 'expiry_date' ], $_POST[ 'expiry_date_hour' ], $_POST[ 'expiry_date_minute' ], $_POST[ 'expiry_date_second' ] ) && ! empty( $_POST[ 'expiry_date' ] ) ) {
			$props[ 'date_expiry' ] = strtotime( wc_clean( wp_unslash( $_POST[ 'expiry_date' ] ) ) . ' ' . ( int ) wc_clean( wp_unslash( $_POST[ 'expiry_date_hour' ] ) ) . ':' . ( int ) wc_clean( wp_unslash( $_POST[ 'expiry_date_minute' ] ) ) . ':' . ( int ) wc_clean( wp_unslash( $_POST[ 'expiry_date_second' ] ) ) ) ;

			if ( ! $quote_request->get_date_expiry( 'edit' ) || $props[ 'date_expiry' ] !== $quote_request->get_date_expiry( 'edit' )->getTimestamp() ) {
				$expiry_date_updated = true ;
			}
		}

		// Set created via prop if new post.
		if ( isset( $_POST[ 'original_post_status' ] ) && 'auto-draft' === $_POST[ 'original_post_status' ] ) {
			$props[ 'created_via' ] = 'admin' ;
		}

		// Save quote request data.
		$quote_request->set_props( $props ) ;

		if ( isset( $_POST[ 'order_status' ] ) ) {
			$quote_request->update_status( wc_clean( wp_unslash( $_POST[ 'order_status' ] ) ), '', true, 'admin' ) ;

			if ( $expiry_date_updated ) {
				/* translators: 1: quote request expiry date */
				$quote_request->add_order_note( sprintf( __( 'Admin manually scheduled the expiry on %s.', 'quote-request-for-woocommerce' ), $quote_request->get_date_expiry() ) ) ;
			}
		}

		$quote_request->save() ;
	}

	/**
	 * Return the array of fieldset for the given address.
	 * 
	 * @param string $address
	 * @return array
	 */
	public static function get_address_fields( $address = 'billing' ) {
		if ( 'shipping' === $address ) {
			return self::$shipping_fields ;
		} else {
			return self::$billing_fields ;
		}
	}

}
