<?php

defined( 'ABSPATH' ) || exit ;

if ( ! class_exists( 'QTS_Email_Customer_Payment_Reminder', false ) ) {

	/**
	 * Payment Reminder Email to Customer.
	 * 
	 * Multiple reminder email will be sent to the customer to pay his accepted/approved quote request.
	 *
	 * @class QTS_Email_Customer_Payment_Reminder
	 * @package class
	 * @extends QTS_Abstract_Email
	 */
	class QTS_Email_Customer_Payment_Reminder extends QTS_Abstract_Email {

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->id             = QTS_PREFIX . 'customer_payment_reminder' ;
			$this->customer_email = true ;
			$this->title          = __( 'Payment Reminder', 'quote-request-for-woocommerce' ) ;
			$this->description    = __( 'Payment Reminder emails are sent to the customer to pay his accepted/approved quote request', 'quote-request-for-woocommerce' ) ;

			$this->template_html  = 'emails/customer-payment-reminder.php' ;
			$this->template_plain = 'emails/plain/customer-payment-reminder.php' ;

			$this->subject = __( '[{site_title}] - Quote Payment Reminder', 'quote-request-for-woocommerce' ) ;
			$this->heading = __( 'Quote Payment Reminder.', 'quote-request-for-woocommerce' ) ;

			// Triggers for this email.
			add_action( 'qts_remind_customer_to_pay_notification', array( $this, 'trigger' ) ) ;

			// Call parent constructor
			parent::__construct() ;
		}

		/**
		 * Get content args.
		 *
		 * @return array
		 */
		public function get_content_args() {
			$content_args                            = parent::get_content_args() ;
			$content_args[ 'quote_request' ]             = $this->object ;
			$content_args[ 'user_nicename' ]         = stripslashes( $this->user->user_nicename ) ;
			$content_args[ 'user_login' ]            = stripslashes( $this->user->user_login ) ;
			$content_args[ 'quote_request_expiry_date' ] = _qts_get_job_scheduled( 'quote_request', 'do_expire', $this->object->get_id() ) ;

			return $content_args ;
		}

		/**
		 * Trigger the sending of this email.
		 *
		 * @param QTS_Quote_Request $quote_request
		 */
		public function trigger( $quote_request ) {
			if ( ! is_object( $quote_request ) ) {
				$quote_request_id = absint( $quote_request ) ;
				$quote_request    = _qts_get_quote_request( $quote_request_id ) ;
			}

			$this->object    = $quote_request ;
			$this->user      = new WP_User( $quote_request->get_user_id() ) ;
			$this->recipient = $quote_request->get_billing_email() ;

			$this->maybe_trigger() ;
		}

	}

}

return new QTS_Email_Customer_Payment_Reminder() ;
