<?php
/**
 * Request a Quote Form.
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/quote/quote-request-form.php.
 */
defined( 'ABSPATH' ) || exit ;

global $current_user ;
?>
<form class="qts-quote-request-form" action="<?php echo esc_url( _qts_get_quote_url() ) ; ?>" method="post" enctype="multipart/form-data">
	<h4><?php esc_html_e( 'Your Details', 'quote-request-for-woocommerce' ) ; ?></h4>
	<?php
	foreach ( $fields as $field_key => $field ) {
		woocommerce_form_field( $field_key, $field, QTS_Form_Fields::get_value( $field_key ) ) ;
	}
	?>
	<input type="submit" name="request_quote" value="<?php esc_html_e( 'Request for a Quote', 'quote-request-for-woocommerce' ) ; ?>"/>
	<?php wp_nonce_field( 'qts-quote-request', QTS_PREFIX . 'nonce' ) ; ?> 
</form>

