/* global qts_frontend */

jQuery( function ( $ ) {
	'use strict' ;

	// qts_frontend is required to continue, ensure the object exists
	if ( typeof qts_frontend === 'undefined' ) {
		return false ;
	}

	var is_blocked = function ( $node ) {
		return $node.is( '.processing' ) || $node.parents( '.processing' ).length ;
	} ;

	/**
	 * Block a node visually for processing.
	 *
	 * @param {JQuery Object} $node
	 */
	var block = function ( $node ) {
		$.blockUI.defaults.overlayCSS.cursor = 'wait' ;

		if ( ! is_blocked( $node ) ) {
			$node.addClass( 'processing' ).block( {
				message : null,
				overlayCSS : {
					background : '#fff',
					opacity : 0.6
				}
			} ) ;
		}
	} ;

	/**
	 * Unblock a node after processing is complete.
	 *
	 * @param {JQuery Object} $node
	 */
	var unblock = function ( $node ) {
		$node.removeClass( 'processing' ).unblock() ;
	} ;

	var formatUrl = function ( url ) {
		if ( - 1 === url.indexOf( 'https://' ) || - 1 === url.indexOf( 'http://' ) ) {
			return url ;
		} else {
			return decodeURI( url ) ;
		}
	}

	/**
	 * Handle Add to Quote events for modes 1&2.
	 */
	var add_to_quote = {
		wrapper : $( '.qts-add-to-quote-wrapper' ),
		variationForm : $( '.variations_form' ),
		cartForm : $( 'form.cart' ),
		init : function () {
			this.triggerOnPageLoad() ;

			$( document ).on( 'found_variation.wc-variation-form', this.onFoundVariation ) ;
			$( document ).on( 'reset_data', this.onResetVariation ) ;
			$( document ).on( 'click', 'a.add-to-qtsquote', this.addToQuote ) ;
			$( document ).on( 'change', '#add_to_qtsquote_mode', this.onToggleQuoteModes ) ;

			if ( this.wrapper.length > 0 ) {
				this.wrapper.on( 'added_to_quote', this.ajaxAddedToQuote ) ;
			}
		},
		triggerOnPageLoad : function ( evt ) {
			if ( add_to_quote.wrapper.closest( 'form.cart' ).find( '#add_to_qtsquote_mode' ).length ) {
				var $chosen_mode = add_to_quote.wrapper.closest( 'form.cart' ).find( '#add_to_qtsquote_mode' ).val() ;

				if ( 'approx' !== $chosen_mode && 'accurate' !== $chosen_mode ) {
					add_to_quote.wrapper.closest( 'form.cart' ).find( 'a.add-to-qtsquote' ).hide() ;
				}
			}
		},
		onFoundVariation : function ( evt, variation ) {
			add_to_quote.onResetVariation() ;

			if ( variation._qts_add_to_quote ) {
				add_to_quote.variationForm.find( '.woocommerce-variation-add-to-cart' ).after( variation._qts_add_to_quote ) ;

				if ( add_to_quote.variationForm.find( '#add_to_qtsquote_mode' ).length ) {
					var $chosen_mode = add_to_quote.variationForm.find( '#add_to_qtsquote_mode' ).val() ;

					if ( 'approx' !== $chosen_mode && 'accurate' !== $chosen_mode ) {
						add_to_quote.variationForm
								.find( '#add_to_qtsquote_mode' )
								.closest( '.qts-add-to-quote-wrapper' )
								.find( 'a.add-to-qtsquote' )
								.hide() ;
					}
				}
			}
		},
		onResetVariation : function ( evt, variation ) {
			if ( add_to_quote.variationForm.find( '.qts-add-to-quote-wrapper' ).length ) {
				add_to_quote.variationForm.find( '.qts-add-to-quote-wrapper' ).remove() ;
			}
		},
		addToQuote : function ( evt ) {
			var $thisButton = $( this ),
					$data = {
						action : '_qts_add_to_quote',
						security : qts_frontend.add_to_quote_nonce,
						product_id : $( evt.currentTarget ).data( 'product_id' ),
						data : 0 === add_to_quote.cartForm.length ? '' : add_to_quote.cartForm.serialize(),
			} ;

			if ( 'yes' === qts_frontend.prompt_guest_to_log_in ) {
				window.alert( qts_frontend.i18n_prompt_guest_to_log_in ) ;
				return false ;
			}

			if ( '' !== qts_frontend.session_mode && 0 !== $thisButton.closest( '.qts-add-to-quote-wrapper' ).find( '#add_to_qtsquote_mode' ).length ) {
				if ( qts_frontend.session_mode !== $thisButton.closest( '.qts-add-to-quote-wrapper' ).find( '#add_to_qtsquote_mode' ).val() ) {
					if ( ! confirm( qts_frontend.i18n_confirm_before_flushing_mode ) ) {
						return false ;
					}
				}
			}

			if ( $thisButton.is( '.ajax-add-to-qtsquote' ) ) {
				$thisButton.removeClass( 'added' ).addClass( 'loading' ) ;
				$data = $.extend( {
					adding_qtsquote : '1',
					ajax_add_to_quote : 'yes'
				}, $data ) ;
			} else if ( $thisButton.is( '.single-add-to-qtsquote' ) ) {
				block( add_to_quote.cartForm ) ;
			}

			if ( $thisButton.is( '.ajax-add-to-qtsquote' ) || $thisButton.is( '.single-add-to-qtsquote' ) ) {
				evt.preventDefault() ;

				$.ajax( {
					type : 'POST',
					url : qts_frontend.ajax_url,
					dataType : 'json',
					data : $data,
					success : function ( response ) {
						if ( response.data.redirect_url ) {
							window.location = formatUrl( response.data.redirect_url ) ;
						} else if ( response.data.refresh ) {
							window.location.reload( true ) ;
						} else if ( response.data.view_quote_url ) {
							add_to_quote.wrapper.trigger( 'added_to_quote', [ response.data, $thisButton ] ) ;
						} else if ( response.data.error ) {
							window.alert( response.data.error ) ;
						} else {
							window.alert( qts_frontend.i18n_went_wrong ) ;
						}
					},
				} ) ;
			}
		},
		ajaxAddedToQuote : function ( e, addedToQuoteData, $button ) {
			$button = typeof $button === 'undefined' ? false : $button ;

			if ( $button ) {
				$button.removeClass( 'loading' ).addClass( 'added' ) ;

				//View quote link/Button.
				if ( 0 === $button.parent().find( '.added_to_quote' ).length ) {
					$button.after( ' <a href="' + formatUrl( addedToQuoteData.view_quote_url ) + '" class="added_to_quote">' + qts_frontend.i18n_view_quote_label + '</a>' ) ;
				}
			}
		},
		onToggleQuoteModes : function ( evt ) {
			evt.preventDefault() ;
			block( $( 'form.cart' ) ) ;

			$.ajax( {
				type : 'POST',
				url : qts_frontend.ajax_url,
				dataType : 'json',
				data : {
					action : '_qts_quote_mode_selected',
					security : qts_frontend.quote_mode_selected_nonce,
					product_id : $( evt.currentTarget ).data( 'product_id' ),
					chosen_mode : $( evt.currentTarget ).val()
				},
				success : function ( response ) {
					if ( response.success ) {
						$( 'form.cart' )
								.find( '.qts-add-to-quote-wrapper' )
								.empty()
								.append( response.data.html ) ;
					} else {
						if ( response.data.error ) {
							window.alert( response.data.error ) ;
						} else {
							window.alert( qts_frontend.i18n_went_wrong ) ;
						}
					}

					if ( 'approx' === $( evt.currentTarget ).val() || 'accurate' === $( evt.currentTarget ).val() ) {
						$( 'form.cart' ).find( '.qts-add-to-quote-wrapper, a.add-to-qtsquote' ).show() ;
					} else {
						$( 'form.cart' ).find( '.qts-add-to-quote-wrapper, a.add-to-qtsquote' ).filter( 'a.add-to-qtsquote' ).hide() ;
					}

					unblock( $( 'form.cart' ) ) ;
				},
			} ) ;
		}
	} ;

	/**
	 * Handle when a remove item link is clicked for mode 1.
	 */
	var cart_item_handler = {
		init : function () {
			if ( 'yes' === qts_frontend.empty_cart_when_awaiting_for_payment ) {
				$( '.woocommerce-cart-form' ).on( 'click', '.product-remove > a', this.item_remove_clicked ) ;
			}
		},
		item_remove_clicked : function ( evt ) {
			if ( confirm( qts_frontend.i18n_confirm_before_flushing_cart ) ) {
				return true ;
			}

			return false ;
		}
	} ;

	/**
	 * Save customer note before submitting the quote request for modes 2.
	 */
	var save_customer_note = {
		wrapper : $( '#qts_customer_note_field' ),
		init : function () {
			if ( this.wrapper.length > 0 ) {
				this.wrapper
						.on( 'click', 'a.qts-save-note', this.save )
						.on( 'click', 'a.qts-clear-note', this.save ) ;
			}
		},
		save : function ( evt ) {
			evt.preventDefault() ;
			block( save_customer_note.wrapper ) ;
			save_customer_note.wrapper.find( 'span.qts-notice' ).empty().show() ;

			$.ajax( {
				type : 'POST',
				url : qts_frontend.ajax_url,
				dataType : 'json',
				data : {
					action : '_qts_save_customer_note',
					security : qts_frontend.save_customer_note_nonce,
					saved : $( evt.currentTarget ).hasClass( 'qts-save-note' ) ? true : '',
					note : save_customer_note.wrapper.find( 'textarea' ).val()
				},
				success : function ( response ) {
					unblock( save_customer_note.wrapper ) ;
					save_customer_note.wrapper.find( 'textarea' ).val( response.data.note ? response.data.note : '' ) ;

					if ( response.success ) {
						save_customer_note.wrapper.find( 'span.qts-notice' ).empty().append( response.data.message ).fadeOut( 3000 ) ;
					} else if ( response.data.error ) {
						save_customer_note.wrapper.find( 'span.qts-notice' ).empty().append( response.data.error ).fadeOut( 3000 ) ;
					} else {
						save_customer_note.wrapper.find( 'span.qts-notice' ).empty().append( qts_frontend.i18n_went_wrong ).fadeOut( 3000 ) ;
					}
				},
			} ) ;
		},
	} ;

	/**
	 * Send the customer note to admin in the View Quote Request page.
	 */
	var send_note_to_admin = {
		init : function () {
			$( 'div.qts-view-quote-request' ).on( 'click', 'button.qts-send-note', this.send ) ;
			$( 'div.qts-view-quote-request' ).on( 'click', 'button.qts-clear-note', this.clear ) ;

			send_note_to_admin.scrollToRecent() ;
		},
		send : function () {
			if ( ! $( 'textarea#qts_customer_note' ).val() ) {
				return false ;
			}

			block( $( 'div.qts-view-quote-request' ) ) ;

			var data = {
				action : '_qts_send_note_to_admin',
				note : $( 'textarea#qts_customer_note' ).val(),
				quote_request_id : qts_frontend.quote_request_id,
				security : qts_frontend.note_to_admin_nonce
			} ;

			$.ajax( {
				url : qts_frontend.ajax_url,
				data : data,
				type : 'POST',
				success : function ( response ) {
					if ( response.data.html ) {
						$( 'div.qts-view-quote-request' ).empty().append( response.data.html ) ;
					}

					// Update notes.
					if ( response.data.notes_html ) {
						$( 'textarea#qts_customer_note' ).val( '' ) ;
						$( 'ul.qts-conversations' ).empty().append( response.data.notes_html ) ;
					}

					unblock( $( 'div.qts-view-quote-request' ) ) ;
				},
				complete : function () {
					send_note_to_admin.scrollToRecent() ;
				}
			} ) ;
			return false ;
		},
		clear : function () {
			$( 'textarea#qts_customer_note' ).val( '' ) ;
		},
		scrollToRecent : function () {
			if ( $( 'ul.qts-conversations' ).length > 0 ) {
				$( 'ul.qts-conversations' ).scrollTop( 20000 ) ;
			}
		}
	} ;

	/**
	 * Customer actions in the My Quote Requests and View Quote Request page.
	 */
	var customer_actions = {
		quoteRequestsTable : $( 'table.account-qtsquote_requests-table' ),
		viewWrapper : $( 'div.qts-view-quote-request' ),
		init : function () {
			if ( this.quoteRequestsTable.length > 0 ) {
				this.quoteRequestsTable.on( 'click', 'a.accept', this.confirmBeforeAccept ) ;
				this.quoteRequestsTable.on( 'click', 'a.reject', this.confirmBeforeReject ) ;
			}

			if ( this.viewWrapper.length > 0 ) {
				this.viewWrapper.on( 'click', 'a.accept', this.confirmBeforeAccept ) ;
				this.viewWrapper.on( 'click', 'a.reject', this.confirmBeforeReject ) ;
			}
		},
		confirmBeforeAccept : function () {
			if ( confirm( qts_frontend.i18n_confirm_before_accept ) ) {
				return true ;
			}

			return false ;
		},
		confirmBeforeReject : function () {
			if ( confirm( qts_frontend.i18n_confirm_before_reject ) ) {
				return true ;
			}

			return false ;
		}
	} ;

	add_to_quote.init() ;
	cart_item_handler.init() ;
	save_customer_note.init() ;
	send_note_to_admin.init() ;
	customer_actions.init() ;
} ) ;
