<?php

defined( 'ABSPATH' ) || exit ;

if ( ! class_exists( 'QTS_Email_Customer_Quote_Expired', false ) ) {

	/**
	 * Quote Expired Email to Customer.
	 * 
	 * An email will be sent to the customer when the quote is expired.
	 * 
	 * @class QTS_Email_Customer_Quote_Expired
	 * @package class
	 * @extends QTS_Abstract_Email
	 */
	class QTS_Email_Customer_Quote_Expired extends QTS_Abstract_Email {

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->id             = QTS_PREFIX . 'customer_quote_expired' ;
			$this->customer_email = true ;
			$this->title          = __( 'Quote Expired', 'quote-request-for-woocommerce' ) ;
			$this->description    = __( 'Quote Expired emails are sent to the customer when the quote is expired.', 'quote-request-for-woocommerce' ) ;

			$this->template_html  = 'emails/customer-quote-expired.php' ;
			$this->template_plain = 'emails/plain/customer-quote-expired.php' ;

			$this->subject = __( '[{site_title}] - Quote Expired', 'quote-request-for-woocommerce' ) ;
			$this->heading = __( 'Quote Expired', 'quote-request-for-woocommerce' ) ;

			// Triggers for this email.
			add_action( 'qts_quote_request_status_expired_notification', array( $this, 'trigger' ) ) ;

			// Call parent constructor
			parent::__construct() ;
		}

		/**
		 * Get content args.
		 *
		 * @return array
		 */
		public function get_content_args() {
			$content_args                    = parent::get_content_args() ;
			$content_args[ 'quote_request' ]     = $this->object ;
			$content_args[ 'user_nicename' ] = stripslashes( $this->user->user_nicename ) ;
			$content_args[ 'user_login' ]    = stripslashes( $this->user->user_login ) ;

			return $content_args ;
		}

		/**
		 * Trigger the sending of this email.
		 *
		 * @param QTS_Quote_Request $quote_request
		 */
		public function trigger( $quote_request ) {
			if ( ! is_object( $quote_request ) ) {
				$quote_request_id = absint( $quote_request ) ;
				$quote_request    = _qts_get_quote_request( $quote_request_id ) ;
			}

			$this->object    = $quote_request ;
			$this->user      = new WP_User( $quote_request->get_user_id() ) ;
			$this->recipient = $quote_request->get_billing_email() ;

			$this->maybe_trigger() ;
		}

	}

}

return new QTS_Email_Customer_Quote_Expired() ;
