<?php

defined( 'ABSPATH' ) || exit ;

/**
 * Checks if a user has a certain capability.
 *
 * @param array $allcaps All capabilities.
 * @param array $caps    Capabilities.
 * @param array $args    Arguments.
 *
 * @return array The filtered array of all capabilities.
 */
function _qts_customer_has_capability( $allcaps, $caps, $args ) {
	if ( isset( $caps[ 0 ] ) ) {
		switch ( $caps[ 0 ] ) {
			case 'add_to_qtsquote':
				$allcaps[ 'add_to_qtsquote' ] = _qts_the_user_eligible( intval( $args[ 1 ] ), array(
					'limit_by'             => get_option( QTS_PREFIX . 'get_user_select_type' ),
					'users_to_include'     => get_option( QTS_PREFIX . 'get_included_users' ),
					'users_to_exclude'     => get_option( QTS_PREFIX . 'get_excluded_users' ),
					'userroles_to_include' => get_option( QTS_PREFIX . 'get_included_userroles' ),
					'userroles_to_exclude' => get_option( QTS_PREFIX . 'get_excluded_userroles' ),
						) ) ;
				break ;
			case 'view_qtsquote_request':
				$user_id                      = intval( $args[ 1 ] ) ;
				$quote_request                = _qts_get_quote_request( $args[ 2 ] ) ;

				if ( $quote_request && $user_id === $quote_request->get_user_id() ) {
					$allcaps[ 'view_qtsquote_request' ] = true ;
				}
				break ;
			case 'accept_qtsquote_request':
			case 'reject_qtsquote_request':
				$user_id       = intval( $args[ 1 ] ) ;
				$quote_request = _qts_get_quote_request( $args[ 2 ] ) ;

				if ( $quote_request && ( $user_id === $quote_request->get_user_id() || ! $quote_request->get_user_id() ) && $quote_request->get_billing_email() ) {
					$allcaps[ $caps[ 0 ] ] = true ;
				}
				break ;
		}
	}

	return $allcaps ;
}

add_filter( 'user_has_cap', '_qts_customer_has_capability', 10, 3 ) ;

/**
 * Get WP User roles
 * 
 * @global WP_Roles $wp_roles
 * @param bool $include_guest
 * @return array
 */
function _qts_get_user_roles( $include_guest = false ) {
	global $wp_roles ;
	$user_role_key  = array() ;
	$user_role_name = array() ;

	foreach ( $wp_roles->roles as $_user_role_key => $user_role ) {
		$user_role_key[]  = $_user_role_key ;
		$user_role_name[] = $user_role[ 'name' ] ;
	}

	$user_roles = array_combine( ( array ) $user_role_key, ( array ) $user_role_name ) ;

	if ( $include_guest ) {
		$user_roles = array_merge( $user_roles, array( 'guest' => 'Guest' ) ) ;
	}

	return $user_roles ;
}

/**
 * Check whether the given is user is eligible for some cases.
 * 
 * @param int|WP_user $the_user
 * @param array $args Give the filters. 
 * @return bool
 */
function _qts_the_user_eligible( $the_user, $args = array() ) {
	$args = wp_parse_args( $args, array(
		'limit_by'             => 'all-users',
		'users_to_include'     => array(),
		'users_to_exclude'     => array(),
		'userroles_to_include' => array(),
		'userroles_to_exclude' => array(),
			) ) ;

	if ( 'all-users' === $args[ 'limit_by' ] ) {
		return true ;
	}

	include_once( ABSPATH . 'wp-includes/pluggable.php' ) ;
	if ( ! is_a( $the_user, 'WP_user' ) ) {
		if ( is_numeric( $the_user ) ) {
			$the_user = get_user_by( 'id', absint( $the_user ) ) ;
		} else if ( isset( $the_user->ID ) ) {
			$the_user = get_user_by( 'id', absint( $the_user->ID ) ) ;
		}
	}

	switch ( $args[ 'limit_by' ] ) {
		case 'include-users':
			if ( ! $the_user ) {
				return false ;
			}

			foreach ( $args[ 'users_to_include' ] as $_id ) {
				$_user = get_user_by( 'id', $_id ) ;
				if ( ! $_user ) {
					continue ;
				}

				if ( $the_user->data->user_email === $_user->data->user_email ) {
					return true ;
				}
			}
			break ;
		case 'exclude-users':
			if ( ! $the_user ) {
				return false ;
			}

			foreach ( $args[ 'users_to_exclude' ] as $_id ) {
				$_user = get_user_by( 'id', $_id ) ;
				if ( ! $_user ) {
					continue ;
				}

				if ( $the_user->data->user_email === $_user->data->user_email ) {
					return false ;
				}
			}

			return true ;
		case 'include-userroles':
			if ( $the_user ) {
				if ( isset( $the_user->roles[ 0 ] ) && in_array( $the_user->roles[ 0 ], $args[ 'userroles_to_include' ] ) ) {
					return true ;
				}
			} elseif ( in_array( 'guest', $args[ 'userroles_to_include' ] ) ) {
				return true ;
			}
			break ;
		case 'exclude-userroles':
			if ( $the_user ) {
				if ( isset( $the_user->roles[ 0 ] ) && ! in_array( $the_user->roles[ 0 ], $args[ 'userroles_to_exclude' ] ) ) {
					return true ;
				}
			} elseif ( ! in_array( 'guest', $args[ 'userroles_to_exclude' ] ) ) {
				return true ;
			}
			break ;
	}

	return false ;
}
