<?php
/**
 * Quote Acknowledged Email to Customer.
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/emails/customer-quote-acknowledged.php
 */
defined( 'ABSPATH' ) || exit ;
?>

<?php do_action( 'woocommerce_email_header', $email_heading, $email ) ; ?>

<p>
	<?php
	/* translators: 1: user name 2: quote request id */
	printf( wp_kses_post( __( 'Hi %1$s, <br>Your Quote <b>#%2$s</b> has been successfully submitted. The Quote details are as follows', 'quote-request-for-woocommerce' ) ), esc_html( $user_nicename ), esc_html( $quote_request->get_id() ) ) ;
	?>
</p>

<?php do_action( 'woocommerce_email_qtsquote_request_details', $quote_request, $sent_to_admin, $plain_text, $email ) ; ?>

<p><?php esc_html_e( 'Thanks', 'quote-request-for-woocommerce' ) ; ?></p>

<?php do_action( 'woocommerce_email_customer_details', $quote_request, $sent_to_admin, $plain_text, $email ); ?>

<?php do_action( 'woocommerce_email_footer', $email ) ; ?>
