<?php

defined( 'ABSPATH' ) || exit ;

/**
 * Quote Request for WooCommerce Autoloader.
 */
class QTS_Autoloader {

	/**
	 * Path to the includes directory.
	 *
	 * @var string
	 */
	private $include_path = '' ;

	/**
	 * Construct QTS_Autoloader
	 */
	public function __construct() {
		$this->include_path = QTS_DIR . 'includes/' ;

		spl_autoload_register( array( $this, 'autoload' ) ) ;
	}

	/**
	 * Auto-load our classes on demand to reduce memory consumption.
	 *
	 * @param string $class Class name.
	 */
	public function autoload( $class ) {
		$class = strtolower( $class ) ;

		//Make sure our classes are going to load
		if ( 0 !== strpos( $class, 'qts_' ) ) {
			return ;
		}

		$file = 'class-' . str_replace( '_', '-', $class ) . '.php' ; //Retrieve file name from class name
		$path = $this->include_path . $file ;

		if ( false !== strpos( $class, '_data_store' ) ) {
			$path = $this->include_path . 'data-stores/' . $file ;
		} else if ( false !== strpos( $class, 'meta_box_' ) ) {
			$path = $this->include_path . 'admin/meta-boxes/' . $file ;
		} else if ( false !== strpos( $class, '_queue' ) ) {
			$path = $this->include_path . 'queue/' . $file ;
		}

		//Include a class file.
		if ( $path && is_readable( $path ) ) {
			include_once $path ;
		}
	}

}

new QTS_Autoloader() ;
