<?php
/**
 * Quote Page
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/quote/quote.php.
 */
defined( 'ABSPATH' ) || exit ;

do_action( 'qts_before_quote' ) ;
?>
<form class="qts-quote-form" action="<?php echo esc_url( _qts_get_quote_url() ) ; ?>" method="post" enctype="multipart/form-data">
	<?php do_action( 'qts_before_quote_table' ) ; ?>
	<table class="qts-quote-table shop_table shop_table_responsive cart" cellspacing="0">
		<thead>
			<tr>
				<th class="product-remove">&nbsp;</th>
				<th class="product-thumbnail">&nbsp;</th>
				<th class="product-name"><?php esc_html_e( 'Product Title', 'quote-request-for-woocommerce' ) ; ?></th>
				<th class="original-price"><?php esc_html_e( 'Price', 'quote-request-for-woocommerce' ) ; ?></th>
				<?php if ( 'yes' === get_option( QTS_PREFIX . 'display_request_price_field' ) ) : ?>
					<th class="preferred-price"><?php esc_html_e( 'Preferred Price', 'quote-request-for-woocommerce' ) ; ?></th>
				<?php endif ; ?>
				<th class="product-quantity"><?php esc_html_e( 'Required Quantity', 'quote-request-for-woocommerce' ) ; ?></th>
				<th class="product-subtotal"><?php esc_html_e( 'Total', 'quote-request-for-woocommerce' ) ; ?></th>
			</tr>
		</thead>
		<tbody>
			<?php do_action( 'qts_before_quote_contents' ) ; ?>
			<?php
			foreach ( _qts()->quote->get_quote() as $quote_item_key => $quote_item ) {
				$_product = $quote_item[ 'data' ] ;

				if ( ! $_product || ! $_product->exists() || $quote_item[ 'quantity' ] <= 0 || ! apply_filters( 'qts_quote_item_visible', true, $quote_item, $quote_item_key ) ) {
					continue ;
				}

				$product_permalink = $_product->is_visible() ? $_product->get_permalink( $quote_item ) : '' ;
				?>
				<tr class="quote_item">
					<td class="product-remove">
						<?php
						printf( '<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">&times;</a>'
								, esc_url( _qts_get_quote_remove_url( $quote_item_key ) )
								, esc_html__( 'Remove this item', 'quote-request-for-woocommerce' )
								, esc_attr( $quote_item[ 'product_id' ] )
								, esc_attr( $_product->get_sku()
						) ) ;
						?>
					</td>
					<td class="product-thumbnail">
						<?php
						if ( ! $product_permalink ) {
							echo wp_kses_post( $_product->get_image() ) ;
						} else {
							printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), wp_kses_post( $_product->get_image() ) ) ;
						}
						?>
					</td>
					<td class="product-name" data-title="<?php esc_attr_e( 'Product Title', 'quote-request-for-woocommerce' ) ; ?>">
						<?php
						if ( ! $product_permalink ) {
							echo wp_kses_post( apply_filters( 'qts_quote_item_name', $_product->get_name(), $quote_item, $quote_item_key ) . '&nbsp;' ) ;
						} else {
							echo wp_kses_post( apply_filters( 'qts_quote_item_name', sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ), $quote_item, $quote_item_key ) ) ;
						}

						do_action( 'qts_after_quote_item_name', $quote_item, $quote_item_key ) ;

						// Meta data.
						echo wp_kses_post( _qts_get_formatted_quote_item_data( $quote_item, false ) ) ;
						?>
					</td>
					<td class="original-price" data-title="<?php esc_attr_e( 'Price', 'quote-request-for-woocommerce' ) ; ?>">
						<?php
						echo wp_kses_post( apply_filters( 'qts_quote_item_original_price', wc_price( $quote_item[ 'original_price' ] ), $quote_item, $quote_item_key ) ) ;
						?>
					</td>
					<?php if ( 'yes' === get_option( QTS_PREFIX . 'display_request_price_field' ) ) : ?>
						<td class="preferred-price" data-title="<?php esc_attr_e( 'Preferred Price', 'quote-request-for-woocommerce' ) ; ?>">
							<input type="number" min="0" max="<?php echo esc_attr( $quote_item[ 'original_price' ] ) ; ?>" step="<?php echo esc_attr( _qts_get_number_input_step_value() ) ; ?>" name="_qts_quote[<?php echo esc_attr( $quote_item_key ) ; ?>][requested_price]" value="<?php echo esc_attr( wc_format_decimal( $quote_item[ 'requested_price' ] ) ) ; ?>"/>
						</td>
					<?php endif ; ?>
					<td class="product-quantity" data-title="<?php esc_attr_e( 'Required Quantity', 'quote-request-for-woocommerce' ) ; ?>">
						<?php
						if ( $_product->is_sold_individually() ) {
							$product_quantity = sprintf( '1 <input type="hidden" name="_qts_quote[%s][qty]" value="1" />', $quote_item_key ) ;
						} else {
							$product_quantity = woocommerce_quantity_input( array(
								'input_name'   => "_qts_quote[{$quote_item_key}][qty]",
								'input_value'  => $quote_item[ 'quantity' ],
								'max_value'    => _qts_allow_unlimited_qty() ? -1 : $_product->get_max_purchase_quantity(),
								'min_value'    => '0',
								'product_name' => $_product->get_name(),
									), $_product, false ) ;
						}

						echo wp_kses( apply_filters( 'qts_quote_item_quantity', $product_quantity, $quote_item_key, $quote_item ), _qts_kses_wc_qty_input_allowed_html() ) ;
						?>
					</td>
					<td class="product-subtotal" data-title="<?php esc_attr_e( 'Total', 'quote-request-for-woocommerce' ) ; ?>">
						<?php
						echo wp_kses_post( apply_filters( 'qts_quote_item_subtotal', _qts()->quote->get_item_subtotal( $quote_item_key ), $quote_item, $quote_item_key ) ) ;
						?>
					</td>
				</tr>
				<?php
			}
			?>
			<?php do_action( 'qts_quote_contents' ) ; ?>
			<tr>
				<td colspan="7">
					<button type="submit" class="button" name="update_quote" value="<?php esc_attr_e( 'Update quote', 'quote-request-for-woocommerce' ) ; ?>"><?php esc_html_e( 'Update quote', 'quote-request-for-woocommerce' ) ; ?></button>
					<?php wp_nonce_field( 'qts-quote', QTS_PREFIX . 'nonce' ) ; ?>
				</td>
			</tr>
			<?php do_action( 'qts_after_quote_contents' ) ; ?>
		</tbody>
	</table>
	<?php do_action( 'qts_after_quote_table' ) ; ?>

	<div class="qts-quote-collaterals">
		<?php
		do_action( 'qts_quote_collaterals' ) ;
		?>
	</div>

	<?php do_action( 'qts_after_quote_collaterals' ) ; ?>
</form>
<?php do_action( 'qts_after_quote' ) ; ?>
