<?php

/**
 * Messages Tab.
 * 
 * @class QTS_Settings_Messages
 * @package Class
 */
class QTS_Settings_Messages extends QTS_Abstract_Settings {

	/**
	 * QTS_Settings_Messages constructor.
	 */
	public function __construct() {

		$this->id       = 'messages' ;
		$this->label    = __( 'Messages', 'quote-request-for-woocommerce' ) ;
		$this->settings = $this->get_settings() ;
		$this->init() ;
	}

	/**
	 * Get settings array.
	 *
	 * @return array
	 */
	public function get_settings() {
		global $current_section ;

		return apply_filters( 'qts_get_' . $this->id . '_settings', array(
			array(
				'name' => __( 'Success Messages', 'quote-request-for-woocommerce' ),
				'type' => 'title',
				'id'   => $this->prefix . 'success_messages'
			),
			array(
				'name'              => __( 'Quote Submitted Success Message - Logged-In Users', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'quote_submitted_success_msg_for_logged_in_users',
				'type'              => 'textarea',
				'default'           => 'Quote Request has been submitted successfully. Your Quote Reference ID is #[quote_request_number]. <a href="[view_quote_request_url]" tabindex="1" class="button wc-forward">View</a>',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Quote Submitted Success Message - Guest Users', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'quote_submitted_success_msg_for_guests',
				'type'              => 'textarea',
				'default'           => 'Quote Request has been submitted successfully. Your Quote Reference ID is #[quote_request_number]. Please check your email for more details.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Complete Payment Message displayed to the User on the Checkout Page', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'complete_payment_msg',
				'type'              => 'textarea',
				'default'           => 'Complete the Payment for the Accepted Quote Request #[quote_request_number].',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array( 'type' => 'sectionend', 'id' => $this->prefix . 'success_messages' ),
			array(
				'name' => __( 'Quote Notices', 'quote-request-for-woocommerce' ),
				'type' => 'title',
				'id'   => $this->prefix . 'quote_notices'
			),
			array(
				'name'              => __( 'Message to Display when Cart Already contains Products while trying to make payment for Accepted Quote in "Approximate Quote" Mode', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'cannot_purchase_normal_products_while_making_payment_notice',
				'type'              => 'textarea',
				'default'           => 'Normal Products cannot be purchased while making payment for Approved Quote Request. Hence the other products has been removed from cart.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Message to Display when the User tries to Modify the Cart while trying to make Payment for the Approved Quote in "Approximate Quote" Mode', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'cannot_modify_cart_while_making_payment_notice',
				'type'              => 'textarea',
				'default'           => 'You cannot modify your cart while making payment for the Approved Quote. If you still wish to proceed, the entire will be emptied.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Guest Login Notice', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'guest_login_notice',
				'type'              => 'textarea',
				'default'           => 'Please login to add products to the Quote Table!!',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Message to be Displayed in "Let the User Decide" Mode, when the User tries to use both the Modes for a Single Quote Request', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'when_user_tries_to_use_both_modes_notice',
				'type'              => 'textarea',
				'default'           => 'Please note that you trying to switch to a new Quote Request Mode, hence the products added in the Previous mode will be Removed. Do you want to continue?',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Accept Quote Confirmation Notice', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'accept_quote_confirmation_notice',
				'type'              => 'textarea',
				'default'           => 'Are you sure you want to accept this Offer? This action cannot be undone.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Quote Reject Confirmation Notice', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'reject_quote_confirmation_notice',
				'type'              => 'textarea',
				'default'           => 'Are you sure you want to reject this Offer? This action cannot be undone.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array( 'type' => 'sectionend', 'id' => $this->prefix . 'quote_notices' ),
			array(
				'name' => __( 'Error Messages', 'quote-request-for-woocommerce' ),
				'type' => 'title',
				'id'   => $this->prefix . 'error_messages'
			),
			array(
				'name'              => __( 'Product Added to Cart Error Message While the Products are in Quote Table - Accurate Quote Mode', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'cannot_add_product_while_getting_a_quote_err',
				'type'              => 'textarea',
				'default'           => 'You cannot add this product to cart as you have started getting a Quote in the Quote Request table.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Product Added to Cart Error Message While trying to Make Quote Request Payment - Approximate Quote Mode', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'cannot_add_product_while_making_payment_err',
				'type'              => 'textarea',
				'default'           => 'You cannot add this product to cart because you have initiated payment for an Approved Quote. Please try adding this product after completing the payment for the Approved Quote.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Cannot Add Products to Quote Table Error Message when Normal Products are in Cart - Accurate Price Mode', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'cannot_add_quote_while_normal_products_in_cart_err',
				'type'              => 'textarea',
				'default'           => 'Your cart already contains normal products. Hence, you cannot add products for getting a Quote.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Cannot Add Products to Quote Error Message', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'cannot_add_quote_while_making_payment_err',
				'type'              => 'textarea',
				'default'           => 'You cannot Request for a Quote for this product because you have initiated payment for an Approved Quote. Please try adding this product after completing the payment for the Approved Quote.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Invalid Quote Request Product Removed from Cart Error Message', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'invalid_quote_products_removed_err',
				'type'              => 'textarea',
				'default'           => 'Invalid Quote Request product removed from cart',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Min Quote Price Error Message', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'cannot_request_less_than_min_price_err',
				'type'              => 'textarea',
				'default'           => 'You cannot request less than [minimum_price] for [product_name]',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Product No Longer Purchasable Error Message', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'product_not_purchasable_err',
				'type'              => 'textarea',
				'default'           => 'This Product is no longer Purchasable.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Product Not in Stock Error Message - Approximate Price Mode', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'product_not_in_stock_err',
				'type'              => 'textarea',
				'default'           => 'Sorry, "[product_name]" is not in stock. We apologize for any inconvenience caused.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Insufficient Stock While Making Payment - Approximate Price Mode', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'insufficient_stock_while_making_payment_err',
				'type'              => 'textarea',
				'default'           => 'Sorry, we do not have enough Stock for "[product_name]" in stock to fulfill your order. Please try back after some time. We apologize for any inconvenience caused.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Sold Individually Error Message on Quote Request Page', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'sold_individual_err_while_adding_quote',
				'type'              => 'textarea',
				'default'           => 'You cannot add another Product to your Quote.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array(
				'name'              => __( 'Coupon Usage Restricted Error Message - Accurate Price Mode', 'quote-request-for-woocommerce' ),
				'id'                => $this->prefix . 'cannot_use_coupon_while_getting_a_quote_err',
				'type'              => 'textarea',
				'default'           => 'You cannot use Coupon While Requesting for Quote.',
				'custom_attributes' => array(
					'rows' => 5,
					'cols' => 5
				)
			),
			array( 'type' => 'sectionend', 'id' => $this->prefix . 'error_messages' ),
				) ) ;
	}

}

return new QTS_Settings_Messages() ;
