<?php

defined( 'ABSPATH' ) || exit ;

if ( ! class_exists( 'QTS_Email_Admin_New_Quote_Request', false ) ) {

	/**
	 * New Quote Request Email to Admin.
	 * 
	 * An email will be sent to the admin when the new quote is submitted by the customer.
	 * 
	 * @class QTS_Email_Admin_New_Quote_Request
	 * @package class
	 * @extends QTS_Abstract_Email
	 */
	class QTS_Email_Admin_New_Quote_Request extends QTS_Abstract_Email {

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->id          = QTS_PREFIX . 'admin_new_quote_request' ;
			$this->title       = __( 'New Quote Request', 'quote-request-for-woocommerce' ) ;
			$this->description = __( 'New Quote Request emails are sent to admin when the new quote is submitted by the customer.', 'quote-request-for-woocommerce' ) ;

			$this->template_html  = 'emails/admin-new-quote-request.php' ;
			$this->template_plain = 'emails/plain/admin-new-quote-request.php' ;

			$this->subject = __( '[{site_title}] - New Quote Request', 'quote-request-for-woocommerce' ) ;
			$this->heading = __( 'New Quote Request', 'quote-request-for-woocommerce' ) ;

			// Triggers for this email.
			add_action( 'qts_quote_request_created_notification', array( $this, 'trigger' ) ) ;

			// Other settings.
			$this->supports = array( 'recipient' ) ;

			// Call parent constructor
			parent::__construct() ;
		}

		/**
		 * Get content args.
		 *
		 * @return array
		 */
		public function get_content_args() {
			$content_args                    = parent::get_content_args() ;
			$content_args[ 'sent_to_admin' ] = true ;
			$content_args[ 'quote_request' ]     = $this->object ;
			$content_args[ 'user_nicename' ] = stripslashes( $this->user->user_nicename ) ;
			$content_args[ 'user_login' ]    = stripslashes( $this->user->user_login ) ;

			return $content_args ;
		}

		/**
		 * Trigger the sending of this email.
		 *
		 * @param QTS_Quote_Request $quote_request
		 */
		public function trigger( $quote_request ) {
			if ( ! is_object( $quote_request ) ) {
				$quote_request_id = absint( $quote_request ) ;
				$quote_request    = _qts_get_quote_request( $quote_request_id ) ;
			}

			$this->object = $quote_request ;
			$this->user   = new WP_User( $quote_request->get_user_id() ) ;

			$this->maybe_trigger() ;
		}

	}

}

return new QTS_Email_Admin_New_Quote_Request() ;
