<?php
/**
 * My Quote Requests.
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/myaccount/my-quote-requests.php.
 */
defined( 'ABSPATH' ) || exit ;

do_action( 'woocommerce_before_account_qtsquote_requests', $has_quote_requests ) ;
?>

<?php if ( $has_quote_requests ) : ?>
	<table class="woocommerce-orders-table woocommerce-MyAccount-orders shop_table shop_table_responsive my_account_orders account-orders-table account-qtsquote_requests-table">
		<thead>
			<tr>
				<?php foreach ( _qts_get_account_quote_requests_columns() as $column_id => $column_name ) : ?>
					<th class="woocommerce-orders-table__header woocommerce-orders-table__header-<?php echo esc_attr( $column_id ) ; ?>"><span class="nobr"><?php echo esc_html( $column_name ) ; ?></span></th>
				<?php endforeach ; ?>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach ( $customer_quote_requests->orders as $customer_quote_request ) {
				$quote_request = _qts_get_quote_request( $customer_quote_request ) ;
				?>
				<tr class="woocommerce-orders-table__row woocommerce-orders-table__row--status-<?php echo esc_attr( $quote_request->get_status() ) ; ?> order qtsquote_request">
					<?php foreach ( _qts_get_account_quote_requests_columns() as $column_id => $column_name ) : ?>
						<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-<?php echo esc_attr( $column_id ) ; ?>" data-title="<?php echo esc_attr( $column_name ) ; ?>">
							<?php if ( has_action( 'woocommerce_my_account_my_qtsquote_requests_column_' . $column_id ) ) : ?>
								<?php do_action( 'woocommerce_my_account_my_qtsquote_requests_column_' . $column_id, $quote_request ) ; ?>
							<?php elseif ( 'quote-request-id' === $column_id ) : ?>
								<a href="<?php echo esc_url( $quote_request->get_view_order_url() ) ; ?>">
									<?php echo esc_html( _x( '#', 'hash before quote request number', 'quote-request-for-woocommerce' ) . $quote_request->get_order_number() ) ; ?>
								</a>
							<?php elseif ( 'quote-request-details' === $column_id ) : ?>
								<?php
								$user_details = _qts_get_account_quote_request_user_details( $quote_request ) ;

								if ( ! empty( $user_details ) ) {
									foreach ( $user_details as $key => $detail ) {
										?>
										<p class="qts-user-<?php echo sanitize_html_class( $key ) ; ?>"><?php echo esc_html( $detail ) ; ?></p>
										<?php
									}
								}
								?>
							<?php elseif ( 'quote-request-date' === $column_id ) : ?>
								<time datetime="<?php echo esc_attr( $quote_request->get_date_created()->date( 'c' ) ) ; ?>"><?php echo esc_html( wc_format_datetime( $quote_request->get_date_created() ) ) ; ?></time>
							<?php elseif ( 'quote-request-status' === $column_id ) : ?>
								<?php echo esc_html( _qts_get_account_quote_request_status( $quote_request ) ) ; ?>
							<?php elseif ( 'quote-request-action' === $column_id ) : ?>
								<?php
								$actions = _qts_get_account_quote_request_actions( $quote_request ) ;

								if ( ! empty( $actions ) ) {
									foreach ( $actions as $key => $_action ) {
										if ( 'pay' === $key ) {
											$target = '_blank' ;
										} else {
											$target = '_self' ;
										}

										echo '<a href="' . esc_url( $_action[ 'url' ] ) . '" target=' . esc_attr( $target ) . ' class="woocommerce-button button ' . sanitize_html_class( $key ) . '">' . esc_html( $_action[ 'name' ] ) . '</a>' ;
									}
								}
								?>
							<?php endif ; ?>
						</td>
					<?php endforeach ; ?>
				</tr>
				<?php
			}
			?>
		</tbody>
	</table>

	<?php do_action( 'woocommerce_before_account_qtsquote_requests_pagination' ) ; ?>

	<?php if ( 1 < $customer_quote_requests->max_num_pages ) : ?>
		<div class="woocommerce-pagination woocommerce-pagination--without-numbers woocommerce-Pagination">
			<?php if ( 1 !== $current_page ) : ?>
				<a class="woocommerce-button woocommerce-button--previous woocommerce-Button woocommerce-Button--previous button" href="<?php echo esc_url( wc_get_endpoint_url( 'quote-requests', $current_page - 1 ) ) ; ?>"><?php esc_html_e( 'Previous', 'quote-request-for-woocommerce' ) ; ?></a>
			<?php endif ; ?>

			<?php if ( intval( $customer_quote_requests->max_num_pages ) !== $current_page ) : ?>
				<a class="woocommerce-button woocommerce-button--next woocommerce-Button woocommerce-Button--next button" href="<?php echo esc_url( wc_get_endpoint_url( 'quote-requests', $current_page + 1 ) ) ; ?>"><?php esc_html_e( 'Next', 'quote-request-for-woocommerce' ) ; ?></a>
			<?php endif ; ?>
		</div>
	<?php endif ; ?>
<?php else : ?>
	<div class="woocommerce-message woocommerce-message--info woocommerce-Message woocommerce-Message--info woocommerce-info">
		<a class="woocommerce-Button button" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ) ; ?>">
			<?php esc_html_e( 'Browse quote request products.', 'quote-request-for-woocommerce' ) ; ?>
		</a>
		<?php esc_html_e( 'No quote request has been made yet.', 'quote-request-for-woocommerce' ) ; ?>
	</div>
<?php endif ; ?>

<?php do_action( 'woocommerce_after_account_qtsquote_requests', $has_quote_requests ) ; ?>
