<?php
/**
 * View Quote Request.
 * Shows the details of a particular quote request on the account page.
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/myaccount/view-quote-request.php.
 */
defined( 'ABSPATH' ) || exit ;

$show_customer_details = is_user_logged_in() && $quote_request->get_user_id() === get_current_user_id() ;
$notes                 = $quote_request->get_conversation_notes() ;
?>
<p>
	<?php
	if ( $quote_request->has_status( array( 'new', 'on_hold' ) ) ) {
		printf(
				/* translators: 1: quote request number 2: quote request date */
				esc_html__( 'Quote Request #%1$s was submitted on %2$s.', 'quote-request-for-woocommerce' ), '<mark class="quote-request-number">' . esc_html( $quote_request->get_order_number() ) . '</mark>', '<mark class="quote-request-date">' . esc_html( wc_format_datetime( $quote_request->get_date_created() ) ) . '</mark>'
		) ;
	} else {
		printf(
				/* translators: 1: quote request number 2: quote request date 3: quote request status */
				esc_html__( 'Quote Request #%1$s was submitted on %2$s and is currently %3$s.', 'quote-request-for-woocommerce' ), '<mark class="quote-request-number">' . esc_html( $quote_request->get_order_number() ) . '</mark>', '<mark class="quote-request-date">' . esc_html( wc_format_datetime( $quote_request->get_date_created() ) ) . '</mark>', '<mark class="quote-request-status">' . esc_html( _qts_get_account_quote_request_status( $quote_request ) ) . '</mark>'
		) ;
	}
	?>
</p>

<section class="qts-account-user-details">
	<?php if ( $quote_request->is_created_via( 'quote' ) ) : ?>
		<h2><?php esc_html_e( 'User Details', 'quote-request-for-woocommerce' ) ; ?></h2>
		<?php
		$user_details = _qts_get_account_quote_request_user_details( $quote_request ) ;

		if ( ! empty( $user_details ) ) {
			foreach ( $user_details as $key => $detail ) {
				?>
				<p class="qts-user-<?php echo sanitize_html_class( $key ) ; ?>"><?php echo esc_html( $detail ) ; ?></p>
				<?php
			}
		}
		?>
	<?php endif ; ?>
</section>

<?php do_action( 'woocommerce_view_qtsquote_request_details', $quote_request_id ) ; ?>

<section class="qts-account-actions">
	<?php
	$actions = _qts_get_account_quote_request_actions( $quote_request ) ;
	unset( $actions[ 'view' ] ) ;

	if ( ! empty( $actions ) ) {
		?>
		<h2><?php esc_html_e( 'Actions', 'quote-request-for-woocommerce' ) ; ?></h2>  
		<?php
		foreach ( $actions as $key => $_action ) {
			if ( 'pay' === $key ) {
				$target = '_blank' ;
			} else {
				$target = '_self' ;
			}

			echo '<a href="' . esc_url( $_action[ 'url' ] ) . '" target=' . esc_attr( $target ) . ' class="woocommerce-button button ' . sanitize_html_class( $key ) . '">' . esc_html( $_action[ 'name' ] ) . '</a>' ;
		}
	}
	?>
</section>

<section class="qts-account-quote-request-conversations">
	<h2><?php esc_html_e( 'Conversations', 'quote-request-for-woocommerce' ) ; ?></h2>

	<ul class="qts-conversations">
		<?php _qts_get_template( 'myaccount/quote-request-conversation-notes.php', array( 'notes' => $notes ) ) ; ?>
	</ul>

	<?php if ( $quote_request->needs_conversation() ) : ?>
		<div class="qts-add-customer-note">
			<p>
				<label for="qts_add_customer_note"><?php esc_html_e( 'Add your note:', 'quote-request-for-woocommerce' ) ; ?></label>
				<textarea type="text" name="qts_customer_note" id="qts_customer_note" class="input-text" cols="2" rows="3"></textarea>
			</p>
			<p>
				<button class="button qts-send-note"><?php esc_html_e( 'Send', 'quote-request-for-woocommerce' ) ; ?></button>
				<button class="button qts-clear-note"><?php esc_html_e( 'Clear', 'quote-request-for-woocommerce' ) ; ?></button>
			</p>
		</div>
	<?php endif ; ?>
</section>

<?php
if ( $show_customer_details ) {
	wc_get_template( 'order/order-details-customer.php', array( 'order' => $quote_request ) ) ;
}
?>

<?php do_action( 'woocommerce_view_qtsquote_request', $quote_request_id ) ; ?>
