<?php

/**
 * Localization Tab.
 * 
 * @class QTS_Settings_Localization
 * @package Class
 */
class QTS_Settings_Localization extends QTS_Abstract_Settings {

	/**
	 * QTS_Settings_Localization constructor.
	 */
	public function __construct() {

		$this->id       = 'localization' ;
		$this->label    = __( 'Localization', 'quote-request-for-woocommerce' ) ;
		$this->settings = $this->get_settings() ;
		$this->init() ;
	}

	/**
	 * Get settings array.
	 *
	 * @return array
	 */
	public function get_settings() {
		global $current_section ;

		return apply_filters( 'qts_get_' . $this->id . '_settings', array(
			array(
				'name' => __( 'Localization Settings', 'quote-request-for-woocommerce' ),
				'type' => 'title',
				'id'   => $this->prefix . 'localization_settings'
			),
			array(
				'name'    => __( 'Add to Quote Button/Link Label', 'quote-request-for-woocommerce' ),
				'id'      => $this->prefix . 'add_to_quote_label',
				'type'    => 'text',
				'default' => 'Add to Quote',
			),
			array(
				'name'    => __( 'Proceed to Quote Button Label', 'quote-request-for-woocommerce' ),
				'id'      => $this->prefix . 'proceed_to_quote_label',
				'type'    => 'text',
				'default' => 'Proceed to Quote',
			),
			array(
				'name'    => __( 'Request for a Quote Button Label', 'quote-request-for-woocommerce' ),
				'id'      => $this->prefix . 'request_for_quote_label',
				'type'    => 'text',
				'default' => 'Request for a Quote',
			),
			array(
				'name'    => __( 'Submit Quote Button Label', 'quote-request-for-woocommerce' ),
				'id'      => $this->prefix . 'submit_quote_label',
				'type'    => 'text',
				'default' => 'Submit Quote',
			),
			array(
				'name'    => __( 'Quote Request Mode Selection Label in Single Product Page when "Let the User Decide" option is Enabled', 'quote-request-for-woocommerce' ),
				'id'      => $this->prefix . 'quote_mode_selection_label',
				'type'    => 'text',
				'default' => 'Quote Request Mode Selection',
			),
			array( 'type' => 'sectionend', 'id' => $this->prefix . 'localization_settings' ),
				) ) ;
	}

}

return new QTS_Settings_Localization() ;
