<?php

defined( 'ABSPATH' ) || exit ;

/**
 * Post Types
 * 
 * Registers post types
 * 
 * @class QTS_Post_Types
 * @package Class
 */
class QTS_Post_Types {

	/**
	 * Init QTS_Post_Types.
	 */
	public static function init() {
		add_action( 'init', __CLASS__ . '::register_post_types' ) ;
		add_action( 'init', __CLASS__ . '::register_post_status' ) ;
		add_filter( 'wc_order_statuses', __CLASS__ . '::get_order_statuses', 99 ) ;
	}

	/**
	 * Register core post types.
	 */
	public static function register_post_types() {

		wc_register_order_type( 'qts_quote_request', array(
			'labels'                           => array(
				'name'               => __( 'Quote Requests', 'quote-request-for-woocommerce' ),
				'singular_name'      => _x( 'Quote Request', 'qts_quote_request post type singular name', 'quote-request-for-woocommerce' ),
				'menu_name'          => _x( 'Quote Requests', 'Admin menu name', 'quote-request-for-woocommerce' ),
				'add_new'            => __( 'Add quote request', 'quote-request-for-woocommerce' ),
				'add_new_item'       => __( 'Add new quote request', 'quote-request-for-woocommerce' ),
				'new_item'           => __( 'New quote request', 'quote-request-for-woocommerce' ),
				'edit_item'          => __( 'Edit quote request', 'quote-request-for-woocommerce' ),
				'view_item'          => __( 'View quote request', 'quote-request-for-woocommerce' ),
				'search_items'       => __( 'Search quote requests', 'quote-request-for-woocommerce' ),
				'not_found'          => __( 'No quote requests found.', 'quote-request-for-woocommerce' ),
				'not_found_in_trash' => __( 'No quote requests found in Trash.', 'quote-request-for-woocommerce' )
			),
			'description'                      => __( 'This is where store quote requests are stored.', 'quote-request-for-woocommerce' ),
			'public'                           => false,
			'show_ui'                          => true,
			'capability_type'                  => 'shop_order',
			'map_meta_cap'                     => true,
			'publicly_queryable'               => false,
			'exclude_from_search'              => true,
			'show_in_menu'                     => 'quote-request-for-woocommerce',
			'hierarchical'                     => false,
			'show_in_nav_menus'                => false,
			'rewrite'                          => false,
			'query_var'                        => false,
			'supports'                         => false,
			'has_archive'                      => false,
			'capabilities'                     => array( 'create_posts' => 'do_not_allow' ),
			'exclude_from_orders_screen'       => true,
			'add_order_meta_boxes'             => true,
			'exclude_from_order_count'         => true,
			'exclude_from_order_views'         => true,
			'exclude_from_order_webhooks'      => true,
			'exclude_from_order_reports'       => true,
			'exclude_from_order_sales_reports' => true,
			'class_name'                       => 'QTS_Quote_Request',
		) ) ;

		if ( ! post_type_exists( 'qts_form_field' ) ) {
			register_post_type( 'qts_form_field', array(
				'labels'          => array(
					'name'               => __( 'Form Fields', 'quote-request-for-woocommerce' ),
					'singular_name'      => _x( 'Form Field', 'qts_form_field post type singular name', 'quote-request-for-woocommerce' ),
					'menu_name'          => _x( 'Form Fields', 'Admin menu name', 'quote-request-for-woocommerce' ),
					'add_new'            => __( 'Add form field', 'quote-request-for-woocommerce' ),
					'add_new_item'       => __( 'Add new form field', 'quote-request-for-woocommerce' ),
					'new_item'           => __( 'New form field', 'quote-request-for-woocommerce' ),
					'edit_item'          => __( 'Edit form field', 'quote-request-for-woocommerce' ),
					'view_item'          => __( 'View form field', 'quote-request-for-woocommerce' ),
					'search_items'       => __( 'Search form fields', 'quote-request-for-woocommerce' ),
					'not_found'          => __( 'No form fields found.', 'quote-request-for-woocommerce' ),
					'not_found_in_trash' => __( 'No form fields found in Trash.', 'quote-request-for-woocommerce' )
				),
				'description'     => __( 'This is where form fields are stored.', 'quote-request-for-woocommerce' ),
				'public'          => false,
				'show_ui'         => true,
				'capability_type' => 'post',
				'show_in_menu'    => 'quote-request-for-woocommerce',
				'rewrite'         => false,
				'has_archive'     => false,
				'supports'        => array( 'title' ),
				'map_meta_cap'    => true,
			) ) ;
		}

		if ( ! post_type_exists( 'qts_scheduled_jobs' ) ) {
			register_post_type( 'qts_scheduled_jobs', array(
				'labels'              => array(
					'name'         => __( 'Scheduled Jobs', 'quote-request-for-woocommerce' ),
					'menu_name'    => _x( 'Scheduled Jobs', 'Admin menu name', 'quote-request-for-woocommerce' ),
					'search_items' => __( 'Search scheduled jobs', 'quote-request-for-woocommerce' ),
					'not_found'    => __( 'No scheduled jobs found.', 'quote-request-for-woocommerce' ),
				),
				'description'         => __( 'This is where scheduled jobs are stored.', 'quote-request-for-woocommerce' ),
				'public'              => false,
				'capability_type'     => 'post',
				'show_ui'             => apply_filters( 'qts_show_scheduled_jobs_post_type_ui', false ),
				'publicly_queryable'  => false,
				'exclude_from_search' => true,
				'show_in_menu'        => 'quote-request-for-woocommerce',
				'hierarchical'        => false,
				'show_in_nav_menus'   => false,
				'rewrite'             => false,
				'query_var'           => false,
				'supports'            => false,
				'has_archive'         => false,
				'map_meta_cap'        => true,
				'capabilities'        => array(
					'create_posts' => 'do_not_allow'
				),
			) ) ;
		}
	}

	/**
	 * Register our post status + order status.
	 */
	public static function register_post_status() {
		$our_statuses = array(
			QTS_PREFIX => array(
				'new'             => array(
					'label'                     => _x( 'New', 'quote request status name', 'quote-request-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: status name */
					'label_count'               => _n_noop( 'New <span class="count">(%s)</span>', 'New <span class="count">(%s)</span>' ),
				),
				'on_hold'         => array(
					'label'                     => _x( 'On Hold', 'quote request status name', 'quote-request-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: status name */
					'label_count'               => _n_noop( 'On Hold <span class="count">(%s)</span>', 'On Hold <span class="count">(%s)</span>' ),
				),
				'accepted'        => array(
					'label'                     => _x( 'Accepted', 'quote request status name', 'quote-request-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: status name */
					'label_count'               => _n_noop( 'Accepted <span class="count">(%s)</span>', 'Accepted <span class="count">(%s)</span>' ),
				),
				'approved'        => array(
					'label'                     => _x( 'Approved', 'quote request status name', 'quote-request-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: status name */
					'label_count'               => _n_noop( 'Approved <span class="count">(%s)</span>', 'Approved <span class="count">(%s)</span>' ),
				),
				'rejected'        => array(
					'label'                     => _x( 'Rejected', 'quote request status name', 'quote-request-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: status name */
					'label_count'               => _n_noop( 'Rejected <span class="count">(%s)</span>', 'Rejected <span class="count">(%s)</span>' ),
				),
				'expired'         => array(
					'label'                     => _x( 'Expired', 'quote request status name', 'quote-request-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: status name */
					'label_count'               => _n_noop( 'Expired <span class="count">(%s)</span>', 'Expired <span class="count">(%s)</span>' ),
				),
				'completed'       => array(
					'label'                     => _x( 'Completed', 'quote request status name', 'quote-request-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: status name */
					'label_count'               => _n_noop( 'Completed <span class="count">(%s)</span>', 'Completed <span class="count">(%s)</span>' ),
				),
				'response_awaitd' => array(
					'label'                     => _x( 'Response Awaited', 'quote request status name', 'quote-request-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: status name */
					'label_count'               => _n_noop( 'Response Awaited <span class="count">(%s)</span>', 'Response Awaited <span class="count">(%s)</span>' ),
				),
				'hav_to_respond'  => array(
					'label'                     => _x( 'Have to Respond', 'quote request status name', 'quote-request-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: status name */
					'label_count'               => _n_noop( 'Have to Respond <span class="count">(%s)</span>', 'Have to Respond <span class="count">(%s)</span>' ),
				),
				'enabled'         => array(
					'label'                     => _x( 'Enabled', 'form field status name', 'quote-request-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: status name */
					'label_count'               => _n_noop( 'Enabled <span class="count">(%s)</span>', 'Enabled <span class="count">(%s)</span>' ),
				),
				'disabled'        => array(
					'label'                     => _x( 'Disabled', 'form field status name', 'quote-request-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: status name */
					'label_count'               => _n_noop( 'Disabled <span class="count">(%s)</span>', 'Disabled <span class="count">(%s)</span>' ),
				),
			),
			'wc-'      => array(
				'qts_new_quote'    => array(
					'label'                     => _x( 'New Quote', 'Quote Request Order status', 'quote-request-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: number of orders */
					'label_count'               => _n_noop( 'New Quote <span class="count">(%s)</span>', 'New Quote <span class="count">(%s)</span>', 'quote-request-for-woocommerce' ),
				),
				'qts_quote_failed' => array(
					'label'                     => _x( 'Quote Failed', 'Quote Request Order status', 'quote-request-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: number of orders */
					'label_count'               => _n_noop( 'Quote Failed <span class="count">(%s)</span>', 'Quote Failed <span class="count">(%s)</span>', 'quote-request-for-woocommerce' ),
				),
			)
				) ;

		foreach ( $our_statuses as $prefix => $statuses ) {
			foreach ( $statuses as $status => $args ) {
				register_post_status( $prefix . $status, $args ) ;
			}
		}
	}

	/**
	 * Return our registered order statuses for WC Order.
	 */
	public static function get_order_statuses( $order_statuses ) {
		$statuses = array(
			'wc-qts_new_quote'    => _x( 'New Quote', 'Quote Request Order status', 'quote-request-for-woocommerce' ),
			'wc-qts_quote_failed' => _x( 'Quote Failed', 'Quote Request Order status', 'quote-request-for-woocommerce' ),
				) ;

		foreach ( $statuses as $status => $status_label ) {
			$order_statuses[ $status ] = $status_label ;
		}
		return $order_statuses ;
	}

}

QTS_Post_Types::init() ;
