<?php

defined( 'ABSPATH' ) || exit ;

/**
 * Add our menus in My Account menu items.
 *
 * @param array $items
 * @return array
 */
function _qts_add_account_menu_items( $items ) {
	$menu     = array( 'quote-requests' => esc_html__( 'My Quote Requests', 'quote-request-for-woocommerce' ) ) ;
	$position = 2 ;
	$items    = array_slice( $items, 0, $position ) + $menu + array_slice( $items, $position, count( $items ) - 1 ) ;
	return $items ;
}

/**
 * Get My Account > Quote Requests columns.
 *
 * @return array
 */
function _qts_get_account_quote_requests_columns() {
	$columns = apply_filters( 'woocommerce_account_qtsquote_requests_columns', array(
		'quote-request-id'      => __( 'Quote ID', 'quote-request-for-woocommerce' ),
		'quote-request-details' => __( 'User Details', 'quote-request-for-woocommerce' ),
		'quote-request-date'    => __( 'Submitted Date', 'quote-request-for-woocommerce' ),
		'quote-request-status'  => __( 'Status', 'quote-request-for-woocommerce' ),
		'quote-request-action'  => __( 'Action', 'quote-request-for-woocommerce' ),
			) ) ;

	return $columns ;
}

/**
 * Get My Account > Quote Requests actions.
 *
 * @param  int|QTS_Quote_Request $quote_request Quote Request
 * @return array
 */
function _qts_get_account_quote_request_actions( $quote_request ) {
	if ( ! is_object( $quote_request ) ) {
		$quote_request_id = absint( $quote_request ) ;
		$quote_request    = _qts_get_quote_request( $quote_request_id ) ;
	}

	$actions = array(
		'view' => array(
			'url'  => $quote_request->get_view_order_url(),
			'name' => __( 'View', 'quote-request-for-woocommerce' ),
		) ) ;

	if ( $quote_request->needs_payment() ) {
		$actions[ 'pay' ] = array(
			'url'  => $quote_request->get_checkout_payment_url(),
			'name' => __( 'Pay', 'quote-request-for-woocommerce' ),
				) ;
	}

	if ( $quote_request->has_status( 'response_awaitd' ) ) {
		$actions[ 'accept' ] = array(
			'url'  => $quote_request->get_accept_quote_request_url( _qts_get_my_quote_requests_url() ),
			'name' => __( 'Accept', 'quote-request-for-woocommerce' )
				) ;
		$actions[ 'reject' ] = array(
			'url'  => $quote_request->get_reject_quote_request_url( _qts_get_my_quote_requests_url() ),
			'name' => __( 'Reject', 'quote-request-for-woocommerce' )
				) ;
	}

	return apply_filters( 'woocommerce_my_account_my_qtsquote_request_actions', $actions, $quote_request ) ;
}

/**
 * Get My Account > Quote Requests user details.
 * 
 * @param int|QTS_Quote_Request $quote_request Quote Request
 * @return array
 */
function _qts_get_account_quote_request_user_details( $quote_request ) {
	if ( ! is_object( $quote_request ) ) {
		$quote_request_id = absint( $quote_request ) ;
		$quote_request    = _qts_get_quote_request( $quote_request_id ) ;
	}

	$first_name = $quote_request->is_created_via( 'quote' ) ? $quote_request->get_meta( '_customer_first_name' ) : $quote_request->get_billing_first_name() ;
	$last_name  = $quote_request->is_created_via( 'quote' ) ? $quote_request->get_meta( '_customer_last_name' ) : $quote_request->get_billing_last_name() ;
	$email      = $quote_request->get_billing_email() ;

	$user_name = trim( $first_name . ' ' . $last_name ) ;
	$user_name = ! empty( $user_name ) ? $user_name : '--' ;

	$user_details = array(
		'name'  => $user_name,
		'email' => $email
			) ;

	return apply_filters( 'woocommerce_my_account_my_qtsquote_request_user_details', $user_details, $quote_request ) ;
}

/**
 * Get My Account > Quote Requests > View Quote Request products table columns.
 * 
 * @param string $requested_price_type
 * @return array
 */
function _qts_get_account_quote_request_products_columns( $requested_price_type = 'fixed' ) {
	$colums = array(
		'product-name'    => __( 'Product Name', 'quote-request-for-woocommerce' ),
		'original-price'  => __( 'Original Price', 'quote-request-for-woocommerce' ),
		'requested-price' => __( 'Requested Price', 'quote-request-for-woocommerce' ),
		'offered-price'   => __( 'Offered Price', 'quote-request-for-woocommerce' ),
		'requested-qty'   => __( 'Requested Quantity', 'quote-request-for-woocommerce' ),
		'total'           => __( 'Total', 'quote-request-for-woocommerce' ),
			) ;

	if ( 'percent' === $requested_price_type ) {
		$colums[ 'requested-price' ] = __( 'Requested Price Percentage', 'quote-request-for-woocommerce' ) ;
	} else if ( 'percent-discount' === $requested_price_type ) {
		$colums[ 'requested-price' ] = __( 'Requested Discount Percentage', 'quote-request-for-woocommerce' ) ;
	}

	$colums = apply_filters( 'woocommerce_account_qtsquote_request_products_columns', $colums ) ;
	return $colums ;
}

/**
 * Get the quote request status to display in My Account > Quote Requests and Quote Requests > View Quote Request.
 * 
 * @param int|QTS_Quote_Request $quote_request Quote Request
 * @return string
 */
function _qts_get_account_quote_request_status( $quote_request ) {
	if ( $quote_request->has_status( 'response_awaitd' ) ) {
		$status = __( 'Need to Reply', 'quote-request-for-woocommerce' ) ;
	} elseif ( $quote_request->has_status( 'hav_to_respond' ) ) {
		$status = __( 'Waiting for Reply', 'quote-request-for-woocommerce' ) ;
	} else {
		$status = _qts_get_quote_request_status_name( $quote_request->get_status() ) ;
	}

	return $status ;
}
