<?php
/**
 * Accepted Quote To Pay Email to Customer.
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/emails/customer-accepted-quote-to-pay.php.
 */
defined( 'ABSPATH' ) || exit ;
?>

<?php do_action( 'woocommerce_email_header', $email_heading, $email ) ; ?>

<p>
	<?php
	/* translators: 1: user name 2: quote request id 3: payment link  */
	printf( wp_kses_post( __( 'Hi %1$s, <br>Please make the payment for the accepted Quote <b>#%2$s</b> using the link below, <br><a href="%3$s">Pay</a>', 'quote-request-for-woocommerce' ) ), esc_html( $user_nicename ), esc_html( $quote_request->get_id() ), esc_url( $quote_request->get_checkout_payment_url() ) ) ;
	?>
</p>

<?php do_action( 'woocommerce_email_qtsquote_request_details', $quote_request, $sent_to_admin, $plain_text, $email ) ; ?>

<p>
	<?php
	if ( $quote_request_expiry_date ) {
		/* translators: 1: quote request expiry date */
		printf( wp_kses_post( __( 'Please make the payment on or before <b>%1$s</b> to prevent the accepted quote from getting expired.', 'quote-request-for-woocommerce' ) ), esc_html( _qts_get_time( 'mysql', array( 'time' => $quote_request_expiry_date ) ) ) ) ;
	}
	?>
</p>

<p><?php esc_html_e( 'Thanks', 'quote-request-for-woocommerce' ) ; ?></p>

<?php do_action( 'woocommerce_email_customer_details', $quote_request, $sent_to_admin, $plain_text, $email ); ?>

<?php do_action( 'woocommerce_email_footer', $email ) ; ?>
