<?php
/**
 * Response Awaited Email to Customer.
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/emails/customer-response-awaited.php.
 */
defined( 'ABSPATH' ) || exit ;
?>

<?php do_action( 'woocommerce_email_header', $email_heading, $email ) ; ?>

<p>
	<?php
	/* translators: 1: user name 2: quote request id */
	printf( wp_kses_post( __( 'Hi %1$s, <br>You have received a new response for the Quote <b>#%2$s</b> from the Site Admin.', 'quote-request-for-woocommerce' ) ), esc_html( $user_nicename ), esc_html( $quote_request->get_id() ) )
	?>
</p>

<?php do_action( 'woocommerce_email_qtsquote_request_details', $quote_request, $sent_to_admin, $plain_text, $email ) ; ?>

<p>
	<?php
	if ( $is_guest ) {
		if ( $quote_request->has_status( 'response_awaitd' ) ) {
			/* translators: 1: quote request accept url 2: quote request reject url */
			printf( wp_kses_post( __( 'To respond to this offer, you can <a href="%1$s">Accept</a> or <a href="%2$s">Reject</a> the quote here itself or please reply to this email.', 'quote-request-for-woocommerce' ) ), esc_url( $quote_request->get_accept_quote_request_url_raw( wc_get_page_permalink( 'myaccount' ) ) ), esc_url( $quote_request->get_reject_quote_request_url_raw( wc_get_page_permalink( 'myaccount' ) ) ) ) ;
		}
	} else {
		/* translators: 1: view quote request url */
		printf( wp_kses_post( __( 'Please login to the site by using the <a href="%1$s">link</a> to respond to this offer.', 'quote-request-for-woocommerce' ) ), esc_url( $quote_request->get_view_order_url() ) ) ;
	}
	?>
</p>

<p><?php esc_html_e( 'Thanks', 'quote-request-for-woocommerce' ) ; ?></p>

<?php do_action( 'woocommerce_email_customer_details', $quote_request, $sent_to_admin, $plain_text, $email ); ?>

<?php do_action( 'woocommerce_email_footer', $email ) ; ?>
