<?php
/**
 * Response Reminder Email to Customer.
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/emails/customer-response-reminder.php.
 */
defined( 'ABSPATH' ) || exit ;
?>

<?php do_action( 'woocommerce_email_header', $email_heading, $email ) ; ?>

<p>
	<?php
	/* translators: 1: user name 2: quote request id */
	printf( wp_kses_post( __( 'Hi %1$s, <br>Site Admin has responded to your Quote <b>#%2$s</b> and they are awaiting a reply.', 'quote-request-for-woocommerce' ) ), esc_html( $user_nicename ), esc_html( $quote_request->get_id() ) )
	?>
</p>

<?php do_action( 'woocommerce_email_qtsquote_request_details', $quote_request, $sent_to_admin, $plain_text, $email ) ; ?>

<p>
	<?php
	if ( $is_guest ) {
		if ( $quote_request->has_status( 'response_awaitd' ) ) {
			/* translators: 1: quote request accept url 2: quote request reject url */
			printf( wp_kses_post( __( 'You can <a href="%1$s">Accept</a> or <a href="%2$s">Reject</a> the quote here itself. ', 'quote-request-for-woocommerce' ) ), esc_url( $quote_request->get_accept_quote_request_url_raw( wc_get_page_permalink( 'myaccount' ) ) ), esc_url( $quote_request->get_reject_quote_request_url_raw( wc_get_page_permalink( 'myaccount' ) ) ) ) ;
		}
	} else {
		/* translators: 1: view quote request url */
		printf( wp_kses_post( __( 'You can log in and view the quote <a href="%1$s">here</a> for more details. ', 'quote-request-for-woocommerce' ) ), esc_url( $quote_request->get_view_order_url() ) ) ;
	}

	if ( $quote_request_expiry_date ) {
		/* translators: 1: quote request expiry date */
		printf( wp_kses_post( __( 'Please respond on or before <b>%1$s</b> to prevent the quote from getting expired.', 'quote-request-for-woocommerce' ) ), esc_html( _qts_get_time( 'mysql', array( 'time' => $quote_request_expiry_date ) ) ) ) ;
	}
	?>
</p>

<p><?php esc_html_e( 'Thanks', 'quote-request-for-woocommerce' ) ; ?></p>

<?php do_action( 'woocommerce_email_customer_details', $quote_request, $sent_to_admin, $plain_text, $email ); ?>

<?php do_action( 'woocommerce_email_footer', $email ) ; ?>
