<?php
/**
 * Quote Request Details.
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/quote-request/quote-request-details.php.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ;
}

$quote_request_items  = $quote_request->get_items( 'line_item' ) ;
$requested_price_type = $quote_request->get_requested_price_type() ;
?>
<section class="qts-quote-request-details">
	<?php do_action( 'woocommerce_qtsquote_request_details_before_quote_request_table', $quote_request ) ; ?>

	<h2><?php esc_html_e( 'Products Table', 'quote-request-for-woocommerce' ) ; ?></h2>

	<table class="woocommerce-orders-table woocommerce-MyAccount-orders shop_table shop_table_responsive my_account_orders account-orders-table account-qtsquote-request-items-table">

		<thead>
			<tr>
				<?php foreach ( _qts_get_account_quote_request_products_columns( $requested_price_type ) as $column_id => $column_name ) : ?>
					<th class="woocommerce-orders-table__header woocommerce-orders-table__header-<?php echo esc_attr( $column_id ) ; ?> qts-quote-request-items-table-header"><span class="nobr"><?php echo esc_html( $column_name ) ; ?></span></th>
				<?php endforeach ; ?>
			</tr>
		</thead>

		<tbody>

			<?php do_action( 'woocommerce_qtsquote_request_details_before_quote_request_table_items', $quote_request ) ; ?>

			<?php
			foreach ( $quote_request_items as $item_id => $item ) {
				$product = $item->get_product() ;
				?>
				<tr class="woocommerce-orders-table__row order qtsquote_request-item" data-quote_request_item_id="<?php echo esc_attr( $item_id ) ; ?>">

					<?php foreach ( _qts_get_account_quote_request_products_columns( $requested_price_type ) as $column_id => $column_name ) : ?>

						<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-<?php echo esc_attr( $column_id ) ; ?>" data-title="<?php echo esc_attr( $column_name ) ; ?>"> 

							<?php if ( 'product-name' === $column_id ) : ?>
								<?php if ( $product ) { ?>
									<a href="<?php echo esc_url( $product->get_permalink( $item ) ) ; ?>"><?php echo wp_kses_post( $item->get_name() ) ; ?></a>
								<?php } else { ?>
									<div class="qts-quote-request-item-name"><?php echo wp_kses_post( $item->get_name() ) ; ?></div>
								<?php } ?>
							<?php elseif ( 'original-price' === $column_id ) : ?>
								<?php echo wp_kses_post( wc_price( $item->get_meta( '_original_price' ), array( 'currency' => $quote_request->get_currency() ) ) ) ; ?>
							<?php elseif ( 'requested-price' === $column_id ) : ?>
								<?php
								if ( is_numeric( $item->get_meta( '_requested_price_percent' ) ) ) {
									echo wp_kses_post( floatval( $item->get_meta( '_requested_price_percent' ) ) ) . '%' ;
								} else if ( is_numeric( $item->get_meta( '_requested_discount_percent' ) ) ) {
									echo wp_kses_post( floatval( $item->get_meta( '_requested_discount_percent' ) ) ) . '%' ;
								} else {
									echo is_numeric( $item->get_meta( '_requested_price' ) ) ? wp_kses_post( wc_price( $item->get_meta( '_requested_price' ), array( 'currency' => $quote_request->get_currency() ) ) ) : '-' ;
								}
								?>
							<?php elseif ( 'offered-price' === $column_id ) : ?>
								<?php echo is_numeric( $item->get_meta( '_offered_price' ) ) ? wp_kses_post( wc_price( $item->get_meta( '_offered_price' ), array( 'currency' => $quote_request->get_currency() ) ) ) : '-' ; ?>
							<?php elseif ( 'requested-qty' === $column_id ) : ?>
								<?php echo 'x' . wp_kses_post( $item->get_quantity() ) ; ?>
							<?php elseif ( 'total' === $column_id ) : ?>
								<?php echo wp_kses_post( wc_price( $item->get_total(), array( 'currency' => $quote_request->get_currency() ) ) ) ; ?>
							<?php endif ; ?>

						</td>

					<?php endforeach ; ?>
				</tr>
			<?php } ?>

			<?php do_action( 'woocommerce_qtsquote_request_details_after_quote_request_table_items', $quote_request ) ; ?>

		</tbody>

		<tfoot>
			<?php
			if ( $quote_request->is_created_via( 'checkout' ) ) {
				$item_totals = $quote_request->get_order_item_totals() ;

				foreach ( $item_totals as $total ) {
					?>
					<tr>
						<th colspan="5" scope="row"><?php echo esc_html( $total[ 'label' ] ) ; ?></th>
						<td data-title="<?php echo esc_attr( $total[ 'label' ] ) ; ?>"><?php echo wp_kses_post( $total[ 'value' ] ) ; ?></td>
					</tr>
					<?php
				}
			}
			?>
		</tfoot>
	</table>

	<?php do_action( 'woocommerce_qtsquote_request_details_after_quote_request_table', $quote_request ) ; ?>
</section>
