/* global qts_admin, ajaxurl */

jQuery( function ( $ ) {
	'use strict';

	// qts_admin is required to continue, ensure the object exists
	if ( typeof qts_admin === 'undefined' ) {
		return false;
	}

	var is_blocked = function ( $node ) {
		return $node.is( '.processing' ) || $node.parents( '.processing' ).length;
	};

	/**
	 * Block a node visually for processing.
	 *
	 * @param {JQuery Object} $node
	 */
	var block = function ( $node ) {
		$.blockUI.defaults.overlayCSS.cursor = 'wait';

		if ( !is_blocked( $node ) ) {
			$node.addClass( 'processing' ).block( {
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.6
				}
			} );
		}
	};

	/**
	 * Unblock a node after processing is complete.
	 *
	 * @param {JQuery Object} $node
	 */
	var unblock = function ( $node ) {
		$node.removeClass( 'processing' ).unblock();
	};

	var formatUrl = function ( url ) {
		if ( -1 === url.indexOf( 'https://' ) || -1 === url.indexOf( 'http://' ) ) {
			return url;
		} else {
			return decodeURI( url );
		}
	}

	$( '._qts_tips' ).tipTip( {
		'attribute': 'data-tip',
		'fadeIn': 50,
		'fadeOut': 50,
		'delay': 200
	} );

	// Type box.
	if ( $( 'body' ).hasClass( 'wc-wp-version-gte-55' ) ) {
		$( '#_qts_form_field_data .form-fields-hidden-box' ).appendTo( '#_qts_form_field_data .hndle' );
	} else {
		$( '#_qts_form_field_data .form-fields-hidden-box' ).appendTo( '#_qts_form_field_data .hndle span' );
	}

	$( function () {
		// Prevent inputs in meta box headings opening/closing contents.
		$( '#_qts_form_field_data' ).find( '.hndle' ).unbind( 'click.postboxes' );
		$( '#_qts_form_field_data' ).on( 'click', '.hndle', function ( event ) {

			// If the user clicks on some form input inside the h3 the box should not be toggled.
			if ( $( event.target ).filter( 'input, option, label, select' ).length ) {
				return;
			}

			$( '#_qts_form_field_data' ).toggleClass( 'closed' );
		} );
	} );

	var admin_form_fields = {
		$wrapper: $( '#_qts_form_field_data' ),

		init: function () {
			if ( 0 === this.$wrapper.length ) {
				return false;
			}

			this.$wrapper.on( 'change', 'select[name="_field_type"]', this.typeSelected );
			this.$wrapper.on( 'click', 'a.add_field_options_row', this.addRow );
			this.$wrapper.on( 'click', 'a.remove_field_options_row', this.removeRow );
			this.$wrapper.find( 'select[name="_field_type"]' ).change();
		},
		typeSelected: function ( evt ) {
			evt.preventDefault();

			admin_form_fields.$wrapper.find( 'table tr.qts-form-field--placeholder-field-row, table tr.qts-form-field--default-field-row' ).show();
			admin_form_fields.$wrapper.find( 'table tr.qts-form-field--options-field-row' ).hide();
			admin_form_fields.$wrapper.find( 'table tr.qts-form-field--default-field-row .woocommerce-help-tip' ).hide();

			switch ( $( evt.currentTarget ).val() ) {
				case 'radio':
				case 'select':
				case 'qts_multiselect':
					admin_form_fields.$wrapper.find( 'table tr.qts-form-field--placeholder-field-row' ).hide();
					admin_form_fields.$wrapper.find( 'table tr.qts-form-field--options-field-row' ).show();
					admin_form_fields.$wrapper.find( 'table tr.qts-form-field--default-field-row .qts_field-options-tip' ).show();
					break;
				case 'checkbox':
					admin_form_fields.$wrapper.find( 'table tr.qts-form-field--placeholder-field-row' ).hide();
					admin_form_fields.$wrapper.find( 'table tr.qts-form-field--default-field-row .qts_field-checkbox-tip' ).show();
					break;
			}
		},
		addRow: function ( evt ) {
			evt.preventDefault();
			var row = $( evt.currentTarget ).data( 'row' );
			$( evt.currentTarget ).closest( 'table' ).find( 'tbody' ).append( row );
			return false;
		},
		removeRow: function ( evt ) {
			evt.preventDefault();
			$( evt.currentTarget ).closest( 'tr' ).remove();
			return false;
		},
	};

	admin_form_fields.init();

	var scrollToRecentConversations = function () {
		if ( $( 'ul.quote_request_conversation_notes' ).length > 0 ) {
			$( 'ul.quote_request_conversation_notes' ).scrollTop( 20000 );
		}
	}

	scrollToRecentConversations();

	/**
	 * Make sure to get the confirmation from the Admin when the offer price entered is invalid.
	 */
	$( '#woocommerce-order-items' ).on( 'click', 'button.save-action', function ( e ) {
		if ( 0 === $( '.woocommerce_order_items' ).find( '.item_offered_price' ).length ) {
			return false;
		}

		var offered_price = parseFloat( $( '.woocommerce_order_items' ).find( '.item_offered_price input' ).val() ),
				original_price = parseFloat( $( '.woocommerce_order_items' ).find( '.item_original_price' ).data( 'sort-value' ) );

		if ( offered_price < 1 ) {
			if ( !window.confirm( qts_admin.il8n_confirm_min_offer_price ) ) {
				e.stopImmediatePropagation();
				return false;
			}
		} else if ( offered_price > original_price ) {
			if ( !window.confirm( qts_admin.il8n_confirm_max_offer_price ) ) {
				e.stopImmediatePropagation();
				return false;
			}
		}
		return false;
	} );

	/**
	 * Add private quote request notes panel.
	 */
	$( '#woocommerce-order-notes' ).on( 'click', 'button.add_qts_note', function () {
		var $this = $( this ),
				$note = $( this ).closest( 'div' ).find( 'textarea#add_qts_note' ).val();

		if ( !$note ) {
			return false;
		}

		block( $( '#woocommerce-order-notes' ) );

		var data = {
			action: '_qts_add_quote_request_private_note',
			post_id: qts_admin.post_id,
			note: $note,
			security: qts_admin.add_private_note_nonce
		};

		$.ajax( {
			url: qts_admin.ajax_url,
			data: data,
			type: 'POST',
			success: function ( response ) {
				if ( response.success ) {
					$this.closest( 'div' ).find( '#add_qts_note' ).val( '' );
					$( '#woocommerce-order-notes' ).find( 'ul.quote_request_notes' ).prepend( response.data.note_html );
				} else {
					window.alert( qts_admin.i18n_went_wrong );
				}

				unblock( $( '#woocommerce-order-notes' ) );
			}
		} );
		return false;
	} );

	/**
	 * Send quote request note to customer.
	 */
	$( '#qts-quote-request-conversation-notes' ).on( 'click', 'button.add_qts_note', function () {
		var $this = $( this ),
				$note = $( this ).closest( 'div' ).find( 'textarea#add_qts_note' ).val();

		if ( !$note ) {
			return false;
		}

		if ( !window.confirm( qts_admin.i18n_prompt_admin_upon_note_to_customer ) ) {
			return false;
		}

		block( $( '#woocommerce-order-data,#qts-quote-request-conversation-notes,#woocommerce-order-notes' ) );

		var data = {
			action: '_qts_send_note_to_customer',
			post_id: qts_admin.post_id,
			note: $note,
			security: qts_admin.note_to_customer_nonce
		};

		$.ajax( {
			url: qts_admin.ajax_url,
			data: data,
			type: 'POST',
			success: function ( response ) {
				if ( response.success ) {
					$( '#woocommerce-order-data' ).find( '.inside' ).empty();
					$( '#woocommerce-order-data' ).find( '.inside' ).append( response.data.html );
					$this.closest( 'div' ).find( '#add_qts_note' ).val( '' );

					$( document.body ).trigger( 'wc-enhanced-select-init' );

					// Update notes.
					if ( response.data.notes_html ) {
						$( '#woocommerce-order-notes' ).find( 'ul.quote_request_notes' ).empty();
						$( '#woocommerce-order-notes' ).find( 'ul.quote_request_notes' ).append( $( response.data.notes_html ).find( 'li' ) );
					}

					if ( response.data.conversation_notes_html ) {
						$( '#qts-quote-request-conversation-notes' ).find( 'ul.quote_request_conversation_notes' ).empty();
						$( '#qts-quote-request-conversation-notes' ).find( 'ul.quote_request_conversation_notes' ).append( $( response.data.conversation_notes_html ).find( 'li' ) );
					}
				} else {
					window.alert( qts_admin.i18n_went_wrong );
				}

				unblock( $( '#woocommerce-order-data,#qts-quote-request-conversation-notes,#woocommerce-order-notes' ) );
			},
			complete: function () {
				scrollToRecentConversations();
			}
		} );
		return false;
	} );

	/**
	 * Delete quote request conversation note.
	 */
	$( '#qts-quote-request-conversation-notes' ).on( 'click', 'a.delete_note', function () {
		if ( window.confirm( qts_admin.i18n_delete_conversation_note ) ) {
			var note = $( this ).closest( 'li.note' );

			block( $( note ) );

			var data = {
				action: 'woocommerce_delete_order_note',
				note_id: $( note ).attr( 'rel' ),
				security: qts_admin.delete_conversation_note_nonce
			};

			$.post( qts_admin.ajax_url, data, function () {
				$( note ).remove();
			} );
		}

		return false;
	} );

	if ( $( 'ul.quote_request_conversation_notes' ).length > 0 ) {
		$( 'ul.quote_request_conversation_notes' ).scrollTop( 20000 );
	}

} );
