<?php

defined( 'ABSPATH' ) || exit ;

/**
 * Quote Request for WooCommerce Admin
 * 
 * @class QTS_Admin
 * @package Class
 */
class QTS_Admin {

	/**
	 * Init QTS_Admin.
	 */
	public static function init() {
		add_action( 'init', __CLASS__ . '::includes' ) ;
		add_action( 'admin_menu', __CLASS__ . '::admin_menus' ) ;
	}

	/**
	 * Include any classes we need within admin.
	 */
	public static function includes() {
		include_once('qts-admin-functions.php') ;
		include_once('class-qts-admin-post-types.php') ;
		include_once('class-qts-admin-meta-boxes.php') ;
		include_once('class-qts-admin-settings.php') ;
	}

	/**
	 * Add admin menu pages.
	 */
	public static function admin_menus() {
		add_menu_page( __( 'Quote Requests', 'quote-request-for-woocommerce' ), __( 'Quote Requests', 'quote-request-for-woocommerce' ), 'manage_woocommerce', 'quote-request-for-woocommerce', null, QTS_URL . '/assets/images/dashicon.png', '57.0' ) ;
		add_submenu_page( 'quote-request-for-woocommerce', __( 'Settings', 'quote-request-for-woocommerce' ), __( 'Settings', 'quote-request-for-woocommerce' ), 'manage_woocommerce', 'qts_settings', 'QTS_Admin_Settings::output' ) ;
	}

}

QTS_Admin::init() ;
