<?php

defined( 'ABSPATH' ) || exit;

/**
 * Remind the customer to respond after the admin is replied.
 * 
 * @param object $item
 */
function qts_quote_request_remind_customer_to_respond_in( $item ) {
	$quote_request = _qts_get_quote_request( $item->quote_request );

	if ( ! $quote_request || $quote_request->has_status( 'trash' ) || ! $quote_request->has_status( 'response_awaitd' ) ) {
		return;
	}

	// Collect the current count of reminders to be sent
	if ( isset( $item->args[ '_reminder_count' ] ) ) {
		$reminder_count = absint( $item->args[ '_reminder_count' ] );
	} else {
		$reminder_count = 1;
	}

	// Collect the total count of reminders to be sent
	if ( isset( $item->args[ '_total_count' ] ) ) {
		$total_count = absint( $item->args[ '_total_count' ] );
	} else {
		$total_count = 1;
	}

	/**
	 * Remind customer to respond in.
	 * 
	 * @param QTS_Quote_Request $quote_request
	 * @param int $reminder_count
	 * @param int $total_count
	 * @since 1.0
	 */
	do_action( 'qts_remind_customer_to_respond_in', $quote_request, $reminder_count, $total_count );
}

/**
 * Remind the customer to pay for their Quote Request after it has been Approved/Accepted.
 * 
 * @param object $item
 */
function qts_quote_request_remind_customer_to_pay( $item ) {
	$quote_request = _qts_get_quote_request( $item->quote_request );

	if ( ! $quote_request || $quote_request->has_status( 'trash' ) || ! $quote_request->needs_payment() ) {
		return;
	}

	// Collect the current count of reminders to be sent
	if ( isset( $item->args[ '_reminder_count' ] ) ) {
		$reminder_count = absint( $item->args[ '_reminder_count' ] );
	} else {
		$reminder_count = 1;
	}

	// Collect the total count of reminders to be sent
	if ( isset( $item->args[ '_total_count' ] ) ) {
		$total_count = absint( $item->args[ '_total_count' ] );
	} else {
		$total_count = 1;
	}

	/**
	 * Remind customer to pay.
	 * 
	 * @param QTS_Quote_Request $quote_request
	 * @param int $reminder_count
	 * @param int $total_count
	 * @since 1.0
	 */
	do_action( 'qts_remind_customer_to_pay', $quote_request, $reminder_count, $total_count );
}

/**
 * Expire the Quote Request when no response from the customer.
 * 
 * @param object $item
 */
function qts_quote_request_do_expire( $item ) {
	$quote_request = _qts_get_quote_request( $item->quote_request );

	if ( ! $quote_request || $quote_request->has_status( 'trash' ) || ! $quote_request->valid_to_expire() ) {
		return;
	}

	$quote_request->update_status( 'expired', __( 'Quote Request expired automatically.', 'quote-request-for-woocommerce' ) );
}

/**
 * Removes schedules belonging to a deleted post.
 *
 * @param mixed $id ID of post being deleted.
 */
function qts_quote_request_delete_post( $id ) {
	if ( ! $id ) {
		return;
	}

	if ( 'qts_quote_request' === get_post_type( $id ) ) {
		_qts_cancel_all_jobs_from_queue( 'quote_request', $id );
	}
}

add_action( 'delete_post', 'qts_quote_request_delete_post' );
