<?php

defined( 'ABSPATH' ) || exit ;

/**
 * Check the currently installed WC version
 * 
 * @param string $comparison_opr The possible operators are: <, lt, <=, le, >, gt, >=, ge, ==, =, eq, !=, <>, ne respectively.
 * This parameter is case-sensitive, values should be lowercase
 * @param string $version
 * @return boolean
 */
function _qts_is_wc_version( $comparison_opr, $version ) {
	if ( defined( 'WC_VERSION' ) && version_compare( WC_VERSION, $version, $comparison_opr ) ) {
		return true ;
	}
	return false ;
}

/**
 * Returns true when viewing an quote page.
 *
 * @return bool
 */
function _qts_is_quote() {
	global $post ;
	$page_id                    = wc_get_page_id( 'qts_quote' ) ;
	$post_content_has_shortcode = is_singular() && is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'qts_quote' ) ;

	return ( $page_id && is_page( $page_id ) ) || defined( 'QTS_QUOTE' ) || $post_content_has_shortcode ;
}

/**
 * Check whether to allow to add to quote unlimited number of quantities.
 * 
 * @return bool
 */
function _qts_allow_unlimited_qty() {
	return 'yes' === get_option( QTS_PREFIX . 'allow_add_to_quote_more_than_available_inventory' ) ? true : false ;
}
