<?php
defined( 'ABSPATH' ) || exit;

/**
 * Quote Request for WooCommerce Admin
 * 
 * @class QTS_Admin
 * @package Class
 */
class QTS_Admin {

	/**
	 * Init QTS_Admin.
	 */
	public static function init() {
		add_action( 'init', __CLASS__ . '::includes' );
		add_action( 'admin_menu', __CLASS__ . '::admin_menus' );
		add_filter( 'parent_file', __CLASS__ . '::remove_duplicate_submenus', 99 );
		add_filter( 'submenu_file', __CLASS__ . '::assign_default_submenu', 99 );
		add_action( 'all_admin_notices', __CLASS__ . '::render_tabs', 5 );
	}

	/**
	 * Include any classes we need within admin.
	 */
	public static function includes() {
		include_once('qts-admin-functions.php');
		include_once('class-qts-admin-post-types.php');
		include_once('class-qts-admin-meta-boxes.php');
		include_once('class-qts-admin-settings.php');
	}

	/**
	 * Add admin menu pages.
	 */
	public static function admin_menus() {
		add_submenu_page( 'woocommerce', __( 'Settings', 'quote-request-for-woocommerce' ), __( 'Settings', 'quote-request-for-woocommerce' ), 'manage_woocommerce', 'qts_settings', 'QTS_Admin_Settings::output' );
	}

	/**
	 * Remove duplicate submenus.
	 * 
	 * @param string $parent_file
	 * @return string
	 */
	public static function remove_duplicate_submenus( $parent_file ) {
		global $submenu;

		if ( ! empty( $submenu[ 'woocommerce' ] ) ) {
			foreach ( $submenu[ 'woocommerce' ] as $key => $item ) {
				if ( isset( $item[ 2 ] ) && _qts_is_screen( $item[ 2 ] ) ) {
					unset( $submenu[ 'woocommerce' ][ $key ] );
				}
			}
		}

		$current_screen = get_current_screen();
		if ( $current_screen && _qts_is_screen( $current_screen->id ) ) {
			$parent_file = 'woocommerce';
		}

		return $parent_file;
	}

	/**
	 * Assign default submenu.
	 * 
	 * @param string $submenu_file
	 * @return string
	 */
	public static function assign_default_submenu( $submenu_file ) {
		$current_screen = get_current_screen();
		if ( $current_screen && _qts_is_screen( $current_screen->id ) ) {
			$submenu_file = 'edit.php?post_type=qts_quote_request';
		}

		return $submenu_file;
	}

	/**
	 * Renders tabs on our custom post types pages.
	 */
	public static function render_tabs() {
		$current_screen = get_current_screen();
		if ( ! $current_screen || ! _qts_is_screen( $current_screen->id ) ) {
			return;
		}

		/**
		 * Get the admin tabs.
		 * 
		 * @since 1.0
		 */
		$tabs = apply_filters( 'qts_admin_tabs', array(
			'quote_requests' => array(
				'title' => __( 'Quote Requests', 'quote-request-for-woocommerce' ),
				'url'   => admin_url( 'edit.php?post_type=qts_quote_request' ),
			),
			'form_fields'    => array(
				'title' => __( 'Form Fields', 'quote-request-for-woocommerce' ),
				'url'   => admin_url( 'edit.php?post_type=qts_form_field' ),
			),
			'settings'       => array(
				'title' => __( 'Settings', 'quote-request-for-woocommerce' ),
				'url'   => admin_url( 'admin.php?page=qts_settings' ),
			),
				) );

		/**
		 * Need to show scheduled jobs menu?
		 * 
		 * @since 1.0
		 */
		if ( apply_filters( 'qts_show_scheduled_jobs_post_type_ui', false ) ) {
			$tabs[ 'scheduled_jobs' ] = array(
				'title' => __( 'Scheduled Jobs', 'quote-request-for-woocommerce' ),
				'url'   => admin_url( 'edit.php?post_type=qts_scheduled_jobs' ),
			);
		}

		if ( _qts_is_screen( $current_screen->id, array( 'qts_quote_request', 'edit-qts_quote_request' ) ) ) {
			$current_tab = 'quote_requests';
		} elseif ( _qts_is_screen( $current_screen->id, array( 'qts_form_field', 'edit-qts_form_field' ) ) ) {
			$current_tab = 'form_fields';
		} elseif ( _qts_is_screen( $current_screen->id, array( 'qts_scheduled_jobs', 'edit-qts_scheduled_jobs' ) ) ) {
			$current_tab = 'scheduled_jobs';
		} else {
			$current_tab = 'settings';
		}

		if ( ! empty( $tabs ) ) {
			?>
			<div class="wrap woocommerce">
				<h2 class="nav-tab-wrapper woo-nav-tab-wrapper">
					<?php foreach ( $tabs as $tab_id => $tab ) : ?>
						<?php $class = $tab_id === $current_tab ? array( 'nav-tab', 'nav-tab-active' ) : array( 'nav-tab' ); ?>
						<?php printf( '<a href="%1$s" class="%2$s">%3$s</a>', esc_url( $tab[ 'url' ] ), implode( ' ', array_map( 'sanitize_html_class', $class ) ), esc_html( $tab[ 'title' ] ) ); ?>
					<?php endforeach; ?>
				</h2>
			</div>
			<?php
		}
	}

}

QTS_Admin::init();
