<?php
/**
 * Form Field Data HTML for meta box.
 */
defined( 'ABSPATH' ) || exit ;
?>
<div class="panel-wrap qts-form-field-data-panel-wrap">
	<span class="form-fields-hidden-box hidden"> &mdash;
		<label for="_field_type">
			<select name="_field_type" <?php disabled( $is_default_field, true, true ) ; ?>>
				<?php foreach ( _qts_get_form_field_types() as $key => $value ) { ?>
					<?php
					if ( ! $is_default_field && in_array( $key, array( 'country', 'state' ) ) ) {
						continue ;
					}
					?>
					<option value="<?php echo esc_attr( $key ) ; ?>" <?php selected( $key, QTS_Form_Fields::get_prop( $field_post_id, 'type', true ), true ) ; ?>><?php echo esc_html( $value ) ; ?></option>
				<?php } ?>
			</select>
		</label>
	</span>    
	<table class="widefat striped qts-form-field-data">
		<tbody>
			<tr class="qts-form-field--options-field-row" style="display: none;">
				<td>
					<label for="_field_options"><?php esc_html_e( 'Field Options', 'quote-request-for-woocommerce' ) ; ?></label>
				</td>
				<td class="field_options_inside">
					<table class="striped" style="width:50%">
						<thead>
							<tr>
								<th><?php esc_html_e( 'Field Option Key', 'quote-request-for-woocommerce' ) ; ?></th>
								<th><?php esc_html_e( 'Field Options Label', 'quote-request-for-woocommerce' ) ; ?></th>
								<th>&nbsp;</th>
							</tr>
						</thead>
						<tbody>
							<?php
							foreach ( QTS_Form_Fields::get_prop( $field_post_id, 'options', true ) as $option_key => $option_value ) {
								include 'html-form-field-options-row.php' ;
							}
							?>
						</tbody>
						<tfoot>
							<tr>
								<td colspan="3"><a href="#" class="button button-primary add_field_options_row" data-row="
									<?php
									ob_start() ;
									$option_key   = '' ;
									$option_value = '' ;
									include 'html-form-field-options-row.php' ;
									echo esc_attr( ob_get_clean() ) ;
									?>
												   "><?php esc_html_e( 'Add', 'quote-request-for-woocommerce' ) ; ?></a></td>
							</tr>
						</tfoot>
					</table>                   
				</td>
			</tr>
			<tr class="qts-form-field--default-field-row">
				<td>
					<label for="_field_default"><?php esc_html_e( 'Field Default Value', 'quote-request-for-woocommerce' ) ; ?></label>
				</td>
				<td>
					<input type="text" name="_field_default" <?php disabled( $is_default_field, true, true ) ; ?> value="<?php echo esc_attr( QTS_Form_Fields::get_prop( $field_post_id, 'default', true ) ) ; ?>" style="width:50%;">
					<span class="woocommerce-help-tip qts_field-checkbox-tip" data-tip="<?php esc_attr_e( 'Set "1" if you want to display the checkbox enabled by default', 'quote-request-for-woocommerce' ) ; ?>"></span>
					<span class="woocommerce-help-tip qts_field-options-tip" data-tip="<?php esc_attr_e( 'Set the "Field Option Key" as default value', 'quote-request-for-woocommerce' ) ; ?>"></span>
				</td>
			</tr>
			<tr class="qts-form-field--placeholder-field-row">
				<td>
					<label for="_field_placeholder"><?php esc_html_e( 'Field Placeholder', 'quote-request-for-woocommerce' ) ; ?></label>
				</td>
				<td>
					<input type="text" name="_field_placeholder" value="<?php echo esc_attr( QTS_Form_Fields::get_prop( $field_post_id, 'placeholder', true ) ) ; ?>" style="width:50%">
				</td>
			</tr>			
			<tr class="qts-form-field--description-field-row">
				<td>
					<label for="_field_description"><?php esc_html_e( 'Field Description', 'quote-request-for-woocommerce' ) ; ?></label>
				</td>
				<td>
					<textarea name="_field_description" rows="3" style="width:50%"><?php echo esc_attr( QTS_Form_Fields::get_prop( $field_post_id, 'description', true ) ) ; ?></textarea>
				</td>
			</tr>
		</tbody>
	</table>
</div>

