<?php
defined( 'ABSPATH' ) || exit;
?>
<div class="wrap woocommerce qts-admin-settings">
	<form method="post" id="mainform" action="" enctype="multipart/form-data">
		<?php
		/**
		 * Get the tabs.
		 * 
		 * @param array $tabs
		 * @since 1.0
		 */
		$_tabs     = apply_filters( 'qts_settings_tabs_array', array() );
		$_tab_keys = array_keys( $_tabs );

		echo '<ul class="subsubsub">';
		foreach ( $_tabs as $slug => $label ) {
			echo '<li><a href="' . esc_url( admin_url( 'admin.php?page=qts_settings&tab=' . esc_attr( $slug ) ) ) . '" class="' . esc_attr( $current_tab == $slug ? 'current' : ''  ) . '">' . esc_html( $label ) . '</a> ' . esc_html( end( $_tab_keys ) == $slug ? '' : '|'  ) . ' </li>';
		}
		echo '</ul><br class="clear" />';

		/**
		 * Add settings tab.
		 * 
		 * @since 1.0
		 */
		do_action( 'qts_settings_tabs' );
		?>
		<?php
		switch ( $current_tab ) :
			default:
				/**
				 * Add settings content based on tab requested.
				 * 
				 * @since 1.0
				 */
				do_action( 'qts_settings_' . $current_tab );
				break;
		endswitch;
		?>
		<?php
		/**
		 * Need save button?
		 * 
		 * @since 1.0
		 */
		if ( apply_filters( 'qts_submit_' . $current_tab, true ) ) :
			?>
			<p class="submit">
				<?php if ( ! isset( $GLOBALS[ 'hide_save_button' ] ) ) : ?>
					<input name="save" class="button-primary" type="submit" value="<?php esc_attr_e( 'Save changes', 'quote-request-for-woocommerce' ); ?>" />
				<?php endif; ?>
				<input type="hidden" name="subtab" id="last_tab" />
				<?php wp_nonce_field( 'qts-settings', QTS_PREFIX . 'nonce' ); ?>
			</p>
		<?php endif; ?>
	</form>
	<?php
	/**
	 * Need reset button?
	 * 
	 * @since 1.0
	 */
	if ( apply_filters( 'qts_reset_' . $current_tab, true ) ) :
		?>
		<form method="post" id="reset_mainform" action="" enctype="multipart/form-data" style="float: left; margin-top: -52px; margin-left: 159px;">
			<input name="reset" class="button-secondary" type="submit" value="<?php esc_attr_e( 'Reset', 'quote-request-for-woocommerce' ); ?>"/>
			<input name="reset_all" class="button-secondary" type="submit" value="<?php esc_attr_e( 'Reset All', 'quote-request-for-woocommerce' ); ?>"/>
			<?php wp_nonce_field( 'qts-reset-settings', QTS_PREFIX . 'nonce' ); ?>
		</form>    
	<?php endif; ?>
</div>
