<?php

defined( 'ABSPATH' ) || exit ;

if ( ! class_exists( 'QTS_Email_Customer_Response_Awaited', false ) ) {

	/**
	 * Response Awaited Email to Customer.
	 * 
	 * An email will be sent to the customer to response when site admin is replied.
	 *
	 * @class QTS_Email_Customer_Response_Awaited
	 * @package class
	 * @extends QTS_Abstract_Email
	 */
	class QTS_Email_Customer_Response_Awaited extends QTS_Abstract_Email {

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->id             = QTS_PREFIX . 'customer_response_awaited' ;
			$this->customer_email = true ;
			$this->title          = __( 'Response Awaited from Customer', 'quote-request-for-woocommerce' ) ;
			$this->description    = __( 'Response Awaited from Customer emails are sent to the customer to response when site admin is replied', 'quote-request-for-woocommerce' ) ;

			$this->template_html  = 'emails/customer-response-awaited.php' ;
			$this->template_plain = 'emails/plain/customer-response-awaited.php' ;

			$this->subject = __( '[{site_title}] - Quote Response Awaited', 'quote-request-for-woocommerce' ) ;
			$this->heading = __( 'Quote Response Awaited', 'quote-request-for-woocommerce' ) ;

			// Triggers for this email.
			add_action( 'qts_quote_request_new_customer_note_added_by_admin_notification', array( $this, 'trigger' ), 10, 3 ) ;

			// Call parent constructor
			parent::__construct() ;
		}

		/**
		 * Get content args.
		 *
		 * @return array
		 */
		public function get_content_args() {
			$content_args                                = parent::get_content_args() ;
			$content_args[ 'quote_request' ]             = $this->object ;
			$content_args[ 'is_guest' ]                  = ! $this->object->get_user_id() ;
			$content_args[ 'user_nicename' ]             = stripslashes( $this->user->user_nicename ) ;
			$content_args[ 'user_login' ]                = stripslashes( $this->user->user_login ) ;
			$content_args[ 'quote_request_expiry_date' ] = _qts_get_job_scheduled( 'quote_request', 'do_expire', $this->object->get_id() ) ;

			return $content_args ;
		}

		/**
		 * Trigger the sending of this email.
		 *
		 * @param QTS_Quote_Request $quote_request
		 */
		public function trigger( $note_id, $note_content, $quote_request ) {
			if ( ! is_object( $quote_request ) ) {
				$quote_request_id = absint( $quote_request ) ;
				$quote_request    = _qts_get_quote_request( $quote_request_id ) ;
			}

			$this->object    = $quote_request ;
			$this->user      = new WP_User( $quote_request->get_user_id() ) ;
			$this->recipient = $quote_request->get_billing_email() ;

			$this->maybe_trigger() ;
		}

	}

}

return new QTS_Email_Customer_Response_Awaited() ;

