<?php

defined( 'ABSPATH' ) || exit ;

if ( ! class_exists( 'QTS_Email_Quote_Completed', false ) ) {

	/**
	 * Quote Completed Email.
	 * 
	 * An email will be sent to the customer when the quote is completed.
	 * 
	 * @class QTS_Email_Quote_Completed
	 * @package class
	 * @extends QTS_Abstract_Email
	 */
	class QTS_Email_Quote_Completed extends QTS_Abstract_Email {

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->id             = QTS_PREFIX . 'quote_completed' ;
			$this->customer_email = true ;
			$this->title          = __( 'Quote Completed', 'quote-request-for-woocommerce' ) ;
			$this->description    = __( 'Quote Completed emails are sent to the customer when the quote is completed.', 'quote-request-for-woocommerce' ) ;

			$this->template_html  = 'emails/quote-completed.php' ;
			$this->template_plain = 'emails/plain/quote-completed.php' ;

			$this->subject = __( '[{site_title}] - Quote Completed', 'quote-request-for-woocommerce' ) ;
			$this->heading = __( 'Quote Completed', 'quote-request-for-woocommerce' ) ;

			// Triggers for this email.
			add_action( 'qts_quote_request_payment_complete_notification', array( $this, 'trigger' ) ) ;

			// Call parent constructor
			parent::__construct() ;
		}

		/**
		 * Get content args.
		 *
		 * @return array
		 */
		public function get_content_args() {
			$content_args                    = parent::get_content_args() ;
			$content_args[ 'quote_request' ] = $this->object ;
			$content_args[ 'user_nicename' ] = stripslashes( $this->user->user_nicename ) ;
			$content_args[ 'user_login' ]    = stripslashes( $this->user->user_login ) ;

			return $content_args ;
		}

		/**
		 * Trigger the sending of this email.
		 *
		 * @param QTS_Quote_Request $quote_request
		 */
		public function trigger( $quote_request ) {
			if ( ! is_object( $quote_request ) ) {
				$quote_request_id = absint( $quote_request ) ;
				$quote_request    = _qts_get_quote_request( $quote_request_id ) ;
			}

			$this->object    = $quote_request ;
			$this->user      = new WP_User( $quote_request->get_user_id() ) ;
			$this->recipient = $quote_request->get_billing_email() ;

			$this->maybe_trigger() ;
		}

		/**
		 * Display form fields
		 */
		public function init_form_fields() {
			parent::init_form_fields() ;

			$this->form_fields[ 'mail_to_admin' ] = array(
				'title'   => __( 'Send Email to Admin', 'quote-request-for-woocommerce' ),
				'type'    => 'checkbox',
				'default' => 'yes'
					) ;
		}

	}

}

return new QTS_Email_Quote_Completed() ;

