<?php
defined( 'ABSPATH' ) || exit;

/**
 * Quote Request Notes.
 * 
 * @class QTS_Meta_Box_Quote_Request_Notes
 * @package Class
 */
class QTS_Meta_Box_Quote_Request_Notes extends WC_Meta_Box_Order_Notes {

	/**
	 * Output the metabox.
	 *
	 * @param WP_Post|QTS_Meta_Box_Quote_Request_Notes $quote_request
	 */
	public static function output( $quote_request ) {
		global $thequote_request;

		if ( $quote_request instanceof WP_Post ) {
			$quote_request = _qts_get_quote_request( $quote_request->ID );
		}

		if ( ! is_object( $thequote_request ) || $thequote_request->get_id() !== $quote_request->get_id() ) {
			$thequote_request = $quote_request;
		}

		$notes = $quote_request->get_quote_request_notes();

		include 'views/html-quote-request-notes.php';
		?>
		<div class="add_note add-qts-private-note">
			<p>
				<label for="add_order_note"><?php esc_html_e( 'Add note', 'quote-request-for-woocommerce' ); ?> <?php echo wc_help_tip( __( 'Add a note for your reference.', 'quote-request-for-woocommerce' ) ); ?></label>
				<textarea type="text" name="order_note" id="add_qts_note" class="input-text add-qts-note" cols="20" rows="5"></textarea>
			</p>
			<p>
				<button type="button" class="add_qts_note button" data-note_type="private"><?php esc_html_e( 'Add private note', 'quote-request-for-woocommerce' ); ?></button>
			</p>
		</div>
		<?php
	}

}
