<?php

/**
 * Our Template Hooks
 *
 * Action/filter hooks used for Our functions/templates.
 */
defined( 'ABSPATH' ) || exit;

/**
 * Quote page.
 */
add_action( 'qts_quote_is_empty', '_qts_empty_quote_message' );
add_action( 'qts_after_quote', '_qts_quote_request_form' );
add_action( 'qts_quote_request_created', '_qts_remove_empty_quote_message', 9 );

/**
 * Cart page.
 */
add_action( 'woocommerce_proceed_to_checkout', '_qts_proceed_to_quote_button', 1 );

/**
 * My Account.
 */
add_filter( 'woocommerce_account_menu_items', '_qts_add_account_menu_items' );
add_action( 'woocommerce_account_quote-requests_endpoint', '_qts_my_quote_requests' );
add_action( 'woocommerce_account_view-quote_endpoint', '_qts_view_quote_request' );

/**
 * Quote Request details.
 */
add_action( 'woocommerce_view_qtsquote_request_details', '_qts_quote_request_details_table' );

/**
 * Quote Basket.
 */
add_action( 'wp_nav_menu_items', '_qts_quote_basket', 10, 2 );
add_action( 'qts_widget_quote_total', '_qts_widget_quote_subtotal' );
add_action( 'qts_widget_quote_buttons', '_qts_widget_quote_button' );
