<?php
defined( 'ABSPATH' ) || exit;

/**
 * Quote Request Conversations.
 * 
 * @class QTS_Meta_Box_Quote_Request_Conversations
 * @package Class
 */
class QTS_Meta_Box_Quote_Request_Conversations {

	/**
	 * Output the metabox.
	 *
	 * @param WP_Post|QTS_Meta_Box_Quote_Request_Conversations $quote_request
	 */
	public static function output( $quote_request ) {
		global $thequote_request;

		if ( $quote_request instanceof WP_Post ) {
			$quote_request = _qts_get_quote_request( $quote_request->ID );
		}

		if ( ! is_object( $thequote_request ) || $thequote_request->get_id() !== $quote_request->get_id() ) {
			$thequote_request = $quote_request;
		}

		$notes = $quote_request->get_conversation_notes();

		include 'views/html-quote-request-conversation-notes.php';

		if ( $quote_request->needs_conversation() ) {
			?>
			<div class="add_note add-qts-conversation-note">
				<p>
					<label for="add_order_note"><?php esc_html_e( 'Add note', 'quote-request-for-woocommerce' ); ?> <?php echo wc_help_tip( __( 'Add a note to customer (the user will be notified).', 'quote-request-for-woocommerce' ) ); ?></label>
					<textarea type="text" name="order_note" id="add_qts_note" class="input-text add-qts-note" cols="20" rows="5"></textarea>
				</p>
				<p>
					<button type="button" class="add_qts_note button-primary" data-note_type="conversation"><?php esc_html_e( 'Send note to customer', 'quote-request-for-woocommerce' ); ?></button>
				</p>
			</div>
			<?php
		} else {
			?>
			<span class="qts-description"><?php echo wc_help_tip( __( 'Valid quote request statuses to send the note are "New","On-hold,"Response Awaited" and "Have to Respond"', 'quote-request-for-woocommerce' ) ); ?> <?php esc_html_e( 'Sending note to customer is no longer available for this quote request.', 'quote-request-for-woocommerce' ); ?></span>            
			<?php
		}
	}
}
