<?php

defined( 'ABSPATH' ) || exit;

/**
 * Quote Request Data.
 * 
 * @class QTS_Meta_Box_Quote_Request_Data
 * @package Class
 */
class QTS_Meta_Box_Quote_Request_Data extends WC_Meta_Box_Order_Data {

	/**
	 * Output the metabox.
	 *
	 * @param WP_Post|QTS_Meta_Box_Quote_Request_Data $quote_request
	 */
	public static function output( $quote_request ) {
		global $thequote_request;

		if ( $quote_request instanceof WP_Post ) {
			$quote_request = _qts_get_quote_request( $quote_request->ID );
		}

		if ( ! is_object( $thequote_request ) || $thequote_request->get_id() !== $quote_request->get_id() ) {
			$thequote_request = $quote_request;
		}

		self::init_address_fields();

		if ( WC()->payment_gateways() ) {
			$payment_gateways = WC()->payment_gateways->payment_gateways();
		} else {
			$payment_gateways = array();
		}

		$quote_request_title = $quote_request->get_data_store()->get_title( $quote_request );
		$payment_method      = $quote_request->get_payment_method();
		$billing_fields      = self::$billing_fields;
		$shipping_fields     = self::$shipping_fields;

		wp_register_style( 'qts-admin-inline', false, '', QTS_VERSION );
		wp_enqueue_style( 'qts-admin-inline' );

		if ( $quote_request->is_created_via( 'quote' ) ) {
			/**
			 * Do allow admin to edit the Line Total/Subtotal, Line/Subtotal Taxes.
			 */
			wp_add_inline_style( 'qts-admin-inline', '
                #post-body-content, #titlediv { display:none }
                body.post-type-qts_quote_request .add-items .button.refund-items,
                body.post-type-qts_quote_request .add-items .description,
                body.post-type-qts_quote_request .add-items .add-coupon,
                body.post-type-qts_quote_request .add-items .add-line-item,
                body.post-type-qts_quote_request .add-order-item,
                body.post-type-qts_quote_request .add-order-fee,
                body.post-type-qts_quote_request .add-order-shipping,
                body.post-type-qts_quote_request .add-order-tax,
                body.woocommerce_page_wc-orders--qts_quote_request .add-items .button.refund-items,
                body.woocommerce_page_wc-orders--qts_quote_request .add-items .description,
                body.woocommerce_page_wc-orders--qts_quote_request .add-items .add-coupon,
                body.woocommerce_page_wc-orders--qts_quote_request .add-items .add-line-item,
                body.woocommerce_page_wc-orders--qts_quote_request .add-order-item,
                body.woocommerce_page_wc-orders--qts_quote_request .add-order-fee,
                body.woocommerce_page_wc-orders--qts_quote_request .add-order-shipping,
                body.woocommerce_page_wc-orders--qts_quote_request .add-order-tax{
                    display: none;
                }

                body.post-type-qts_quote_request  table .line_cost, 
                body.post-type-qts_quote_request  table .line_tax,
                body.post-type-qts_quote_request  table .line_cost .input,
                body.post-type-qts_quote_request  table .line_tax .input,
                body.post-type-qts_quote_request  table .line_cost .input label,
                body.post-type-qts_quote_request  table .line_tax .input label,
                body.post-type-qts_quote_request  table .line_cost .input input,
                body.post-type-qts_quote_request  table .line_tax .input input,
                body.woocommerce_page_wc-orders--qts_quote_request  table .line_cost, 
                body.woocommerce_page_wc-orders--qts_quote_request  table .line_tax,
                body.woocommerce_page_wc-orders--qts_quote_request  table .line_cost .input,
                body.woocommerce_page_wc-orders--qts_quote_request  table .line_tax .input,
                body.woocommerce_page_wc-orders--qts_quote_request  table .line_cost .input label,
                body.woocommerce_page_wc-orders--qts_quote_request  table .line_tax .input label,
                body.woocommerce_page_wc-orders--qts_quote_request  table .line_cost .input input,
                body.woocommerce_page_wc-orders--qts_quote_request  table .line_tax .input input{
                    cursor: not-allowed;
                }
            ' );

			wc_enqueue_js(
					"jQuery( '#woocommerce-order-items' ).on( 'click', 'a.edit-order-item', function () {
                        jQuery( this ).closest( 'tr' ).find( '.edit' ).find( '.line_subtotal, .line_subtotal_tax, .line_total, .line_tax' ).attr( 'readonly', 'readonly' );
                        return false;
                    } );"
			);
		} else {
			/**
			 * Do allow admin to edit the Line Total/Subtotal, Line/Subtotal Taxes except Shipping Items.
			 */
			wp_add_inline_style( 'qts-admin-inline', '
                #post-body-content, #titlediv { display:none }
                body.post-type-qts_quote_request .add-items .button.refund-items,
                body.post-type-qts_quote_request .add-items .description,
                body.post-type-qts_quote_request .add-items .add-coupon,
                body.post-type-qts_quote_request .add-items .add-line-item,
                body.post-type-qts_quote_request .add-order-item,
                body.post-type-qts_quote_request .add-order-fee,
                body.post-type-qts_quote_request .add-order-tax,
                body.woocommerce_page_wc-orders--qts_quote_request .add-items .button.refund-items,
                body.woocommerce_page_wc-orders--qts_quote_request .add-items .description,
                body.woocommerce_page_wc-orders--qts_quote_request .add-items .add-coupon,
                body.woocommerce_page_wc-orders--qts_quote_request .add-items .add-line-item,
                body.woocommerce_page_wc-orders--qts_quote_request .add-order-item,
                body.woocommerce_page_wc-orders--qts_quote_request .add-order-fee,
                body.woocommerce_page_wc-orders--qts_quote_request .add-order-tax{
                    display: none;
                }

                body.post-type-qts_quote_request  table tbody:not(#order_shipping_line_items) .line_cost, 
                body.post-type-qts_quote_request  table tbody:not(#order_shipping_line_items) .line_tax,
                body.post-type-qts_quote_request  table tbody:not(#order_shipping_line_items) .line_cost .input,
                body.post-type-qts_quote_request  table tbody:not(#order_shipping_line_items) .line_tax .input,
                body.post-type-qts_quote_request  table tbody:not(#order_shipping_line_items) .line_cost .input label,
                body.post-type-qts_quote_request  table tbody:not(#order_shipping_line_items) .line_tax .input label,
                body.post-type-qts_quote_request  table tbody:not(#order_shipping_line_items) .line_cost .input input,
                body.post-type-qts_quote_request  table tbody:not(#order_shipping_line_items) .line_tax .input input,
                body.woocommerce_page_wc-orders--qts_quote_request  table tbody:not(#order_shipping_line_items) .line_cost, 
                body.woocommerce_page_wc-orders--qts_quote_request  table tbody:not(#order_shipping_line_items) .line_tax,
                body.woocommerce_page_wc-orders--qts_quote_request  table tbody:not(#order_shipping_line_items) .line_cost .input,
                body.woocommerce_page_wc-orders--qts_quote_request  table tbody:not(#order_shipping_line_items) .line_tax .input,
                body.woocommerce_page_wc-orders--qts_quote_request  table tbody:not(#order_shipping_line_items) .line_cost .input label,
                body.woocommerce_page_wc-orders--qts_quote_request  table tbody:not(#order_shipping_line_items) .line_tax .input label,
                body.woocommerce_page_wc-orders--qts_quote_request  table tbody:not(#order_shipping_line_items) .line_cost .input input,
                body.woocommerce_page_wc-orders--qts_quote_request  table tbody:not(#order_shipping_line_items) .line_tax .input input{
                    cursor: not-allowed;
                }
            ' );

			wc_enqueue_js(
					"jQuery( '#woocommerce-order-items' ).on( 'click', 'a.edit-order-item', function () {
                        jQuery( this ).closest( 'tr:not(.shipping)' ).find( '.edit' ).find( '.line_subtotal, .line_subtotal_tax, .line_total, .line_tax' ).attr( 'readonly', 'readonly' );
                        return false;
                    } );"
			);
		}

		wp_nonce_field( 'woocommerce_save_data', 'woocommerce_meta_nonce' );

		include 'views/html-quote-request-data.php';
	}

	/**
	 * Save meta box data.
	 *
	 * @param int $quote_request_id
	 * @param QTS_Quote_Request $quote_request
	 */
	public static function save( $quote_request_id, $quote_request = null ) {
		if ( ! _qts_is_quote_request( $quote_request_id ) || empty( $_POST[ 'woocommerce_meta_nonce' ] ) || ! wp_verify_nonce( sanitize_key( $_POST[ 'woocommerce_meta_nonce' ] ), 'woocommerce_save_data' ) ) {
			return;
		}

		self::init_address_fields();

		// Get quote request object.
		$quote_request = _qts_get_quote_request( $quote_request_id );
		$props         = array();

		// Create quote request key.
		if ( ! $quote_request->get_order_key() ) {
			$props[ 'order_key' ] = _qts_generate_key();
		}

		// Update customer.
		$customer_id = isset( $_POST[ 'customer_user' ] ) ? absint( wp_unslash( $_POST[ 'customer_user' ] ) ) : 0;
		if ( $customer_id !== $quote_request->get_customer_id() ) {
			$props[ 'customer_id' ] = $customer_id;
		}

		// Update billing fields.
		if ( ! empty( self::$billing_fields ) ) {
			foreach ( self::$billing_fields as $key => $field ) {
				if ( ! isset( $field[ 'id' ] ) ) {
					$field[ 'id' ] = '_billing_' . $key;
				}

				if ( ! isset( $_POST[ $field[ 'id' ] ] ) ) {
					continue;
				}

				if ( is_callable( array( $quote_request, 'set_billing_' . $key ) ) ) {
					$props[ 'billing_' . $key ] = wc_clean( wp_unslash( $_POST[ $field[ 'id' ] ] ) );
				} else {
					$quote_request->update_meta_data( $field[ 'id' ], wc_clean( wp_unslash( $_POST[ $field[ 'id' ] ] ) ) );
				}
			}
		}

		// Update shipping fields.
		if ( ! empty( self::$shipping_fields ) ) {
			foreach ( self::$shipping_fields as $key => $field ) {
				if ( ! isset( $field[ 'id' ] ) ) {
					$field[ 'id' ] = '_shipping_' . $key;
				}

				if ( ! isset( $_POST[ $field[ 'id' ] ] ) ) {
					continue;
				}

				if ( is_callable( array( $quote_request, 'set_shipping_' . $key ) ) ) {
					$props[ 'shipping_' . $key ] = wc_clean( wp_unslash( $_POST[ $field[ 'id' ] ] ) );
				} else {
					$quote_request->update_meta_data( $field[ 'id' ], wc_clean( wp_unslash( $_POST[ $field[ 'id' ] ] ) ) );
				}
			}
		}

		// Update date.
		if ( empty( $_POST[ 'order_date' ] ) ) {
			$props[ 'date_created' ] = time();
		} elseif ( isset( $_POST[ 'order_date' ], $_POST[ 'order_date_hour' ], $_POST[ 'order_date_minute' ], $_POST[ 'order_date_second' ] ) ) {
				$props[ 'date_created' ] = gmdate( 'Y-m-d H:i:s', strtotime( wc_clean( wp_unslash( $_POST[ 'order_date' ] ) ) . ' ' . ( int ) wc_clean( wp_unslash( $_POST[ 'order_date_hour' ] ) ) . ':' . ( int ) wc_clean( wp_unslash( $_POST[ 'order_date_minute' ] ) ) . ':' . ( int ) wc_clean( wp_unslash( $_POST[ 'order_date_second' ] ) ) ) );
		}

		// Update expiry date.
		$expiry_date_updated = false;
		if ( isset( $_POST[ 'expiry_date' ], $_POST[ 'expiry_date_hour' ], $_POST[ 'expiry_date_minute' ], $_POST[ 'expiry_date_second' ] ) && ! empty( $_POST[ 'expiry_date' ] ) ) {
			$props[ 'date_expiry' ] = strtotime( wc_clean( wp_unslash( $_POST[ 'expiry_date' ] ) ) . ' ' . ( int ) wc_clean( wp_unslash( $_POST[ 'expiry_date_hour' ] ) ) . ':' . ( int ) wc_clean( wp_unslash( $_POST[ 'expiry_date_minute' ] ) ) . ':' . ( int ) wc_clean( wp_unslash( $_POST[ 'expiry_date_second' ] ) ) );

			if ( ! $quote_request->get_date_expiry( 'edit' ) || $props[ 'date_expiry' ] !== $quote_request->get_date_expiry( 'edit' )->getTimestamp() ) {
				$expiry_date_updated = true;
			}
		}

		// Set created via prop if new post.
		if ( isset( $_POST[ 'original_post_status' ] ) && 'auto-draft' === $_POST[ 'original_post_status' ] ) {
			$props[ 'created_via' ] = 'admin';
		}

		// Save quote request data.
		$quote_request->set_props( $props );

		if ( isset( $_POST[ 'order_status' ] ) ) {
			$quote_request->update_status( wc_clean( wp_unslash( $_POST[ 'order_status' ] ) ), '', true, 'admin' );

			if ( $expiry_date_updated ) {
				/* translators: 1: quote request expiry date */
				$quote_request->add_order_note( sprintf( __( 'Admin manually scheduled the expiry on %s.', 'quote-request-for-woocommerce' ), $quote_request->get_date_expiry() ) );
			}
		}

		$quote_request->save();
	}

	/**
	 * Return the array of fieldset for the given address.
	 * 
	 * @param string $address
	 * @return array
	 */
	public static function get_address_fields( $address = 'billing' ) {
		if ( 'shipping' === $address ) {
			return self::$shipping_fields;
		} else {
			return self::$billing_fields;
		}
	}
}
