<?php

/**
 * Plugin Name: Quote Request for WooCommerce
 * Description: Offer the Flexibility of Requesting for a Quote for the Products Sold on Your WooCommerce Shop to your Customers. 
 * Version: 2.8.0
 * Author: Flintop
 * Author URI: https://flintop.com
 * Text Domain: quote-request-for-woocommerce
 * Domain Path: /languages
 * Woo: 5638677:e70ed7e50b520d548bf904386b00e516
 * Tested up to: 6.3.2
 * WC tested up to: 8.2.0
 * WC requires at least: 3.5
 * Copyright: © 2023 Flintop
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
defined( 'ABSPATH' ) || exit;

if ( ! defined( 'QTS_FILE' ) ) {
	define( 'QTS_FILE', __FILE__ );
}

// Include the main Quote Request class.
if ( ! class_exists( 'WC_Quote_Request', false ) ) {
	include_once dirname( QTS_FILE ) . '/includes/class-wc-quote-request.php';
}

/**
 * Add HPOS support.
 */
add_action( 'before_woocommerce_init', function () {
	if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

/**
 * Main instance of WC_Quote_Request.
 * Returns the main instance of WC_Quote_Request.
 *
 * @return WC_Quote_Request
 */
function _qts() {
	return WC_Quote_Request::instance();
}

/**
 * Run Quote Request for WooCommerce
 */
_qts();
