<?php
/**
 * Email Quote Request Items.
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/emails/email-quote-request-items.php.
 */
defined( 'ABSPATH' ) || exit;

$text_align  = is_rtl() ? 'right' : 'left';
$margin_side = is_rtl() ? 'left' : 'right';

foreach ( $items as $item_id => $item ) :
	$product     = $item->get_product();
	$sku         = '';
	$image       = '';
	$product_url = '';

	/**
	 * Is email quote request item visible?
	 * 
	 * @since 1.0
	 */
	if ( ! apply_filters( 'woocommerce_email_qtsquote_request_item_visible', true, $item, $quote_request ) ) {
		continue;
	}

	if ( is_object( $product ) ) {
		$sku         = $product->get_sku();
		$image       = $product->get_image( $image_size );
		$product_url = $product->get_permalink( $item );
	}

	/**
	 * Get email quote request item name.
	 * 
	 * @since 1.0
	 */
	$item_name = apply_filters( 'woocommerce_email_qtsquote_request_item_name', $item->get_name(), $item, $quote_request );
	?>
	<tr class="order_item qtsquote_request_item">

		<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; vertical-align: middle; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; word-wrap:break-word;">
			<?php
			// Show title/image etc.
			if ( $show_image ) {
				/**
				 * Get email quote request item thumbnail.
				 * 
				 * @since 1.0
				 */
				echo wp_kses_post( apply_filters( 'woocommerce_email_qtsquote_request_item_thumbnail', $image, $item, $quote_request ) );
			}

			if ( $show_product_url && $product_url ) {
				?>
				<a href="<?php echo esc_url( $product_url ); ?>"><?php echo wp_kses_post( $item_name ); ?></a>
				<?php
			} else {
				echo wp_kses_post( $item_name );
			}

			// SKU.
			if ( $show_sku && $sku ) {
				echo wp_kses_post( ' (#' . $sku . ')' );
			}

			/**
			 * Allow other plugins to add additional product information here.
			 * 
			 * @since 1.0
			 */
			do_action( 'woocommerce_email_qtsquote_request_item_meta_start', $item_id, $item, $quote_request, $plain_text );

			wc_display_item_meta( $item, array(
				'label_before' => '<strong class="wc-item-meta-label" style="float: ' . esc_attr( $text_align ) . '; margin-' . esc_attr( $margin_side ) . ': .25em; clear: both">',
			) );

			/**
			 * Allow other plugins to add additional product information here.
			 * 
			 * @since 1.0
			 */
			do_action( 'woocommerce_email_qtsquote_request_item_meta_end', $item_id, $item, $quote_request, $plain_text );
	?>
		</td>

		<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; vertical-align:middle; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;">
			<?php echo wp_kses_post( wc_price( $item->get_meta( '_original_price' ), array( 'currency' => $quote_request->get_currency() ) ) ); ?>
		</td>

		<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; vertical-align:middle; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;">
			<?php
			if ( is_numeric( $item->get_meta( '_requested_price_percent' ) ) ) {
				echo wp_kses_post( floatval( $item->get_meta( '_requested_price_percent' ) ) ) . '%';
			} else if ( is_numeric( $item->get_meta( '_requested_discount_percent' ) ) ) {
				echo wp_kses_post( floatval( $item->get_meta( '_requested_discount_percent' ) ) ) . '%';
			} else {
				echo is_numeric( $item->get_meta( '_requested_price' ) ) ? wp_kses_post( wc_price( $item->get_meta( '_requested_price' ), array( 'currency' => $quote_request->get_currency() ) ) ) : '-';
			}
			?>
		</td>

		<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; vertical-align:middle; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;">
			<?php echo is_numeric( $item->get_meta( '_offered_price' ) ) ? wp_kses_post( wc_price( $item->get_meta( '_offered_price' ), array( 'currency' => $quote_request->get_currency() ) ) ) : '-'; ?>
		</td>

		<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; vertical-align:middle; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;">
			<?php
			$qty_display = 'x' . esc_html( $item->get_quantity() );

			/**
			 * Get email quote request item quantity.
			 * 
			 * @since 1.0
			 */
			echo wp_kses_post( apply_filters( 'woocommerce_email_qtsquote_request_item_quantity', $qty_display, $item, $quote_request ) );
			?>
		</td>

		<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; vertical-align:middle; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;">
			<?php echo wp_kses_post( wc_price( $item->get_total(), array( 'currency' => $quote_request->get_currency() ) ) ); ?>
		</td>

	</tr>    
<?php endforeach; ?>
