<?php
/**
 * Empty quote page
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/quote/quote-empty.php.
 */
defined( 'ABSPATH' ) || exit;

/**
 * Before quote is empty.
 * 
 * @since 1.0
 */
do_action( 'qts_quote_is_empty' );

if ( wc_get_page_id( 'shop' ) > 0 ) :
	?>
	<p class="return-to-shop">
		<a class="button wc-backward" href="
		<?php
		   /**
			* Get redirect to shop url.
			* 
			* @since 1.0
			*/
		   echo esc_url( apply_filters( 'qts_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) );
		?>
		   ">
			   <?php esc_html_e( 'Return to shop', 'quote-request-for-woocommerce' ); ?>
		</a>
	</p>
<?php endif; ?>
