<?php
/**
 * Quote Request data HTML for meta box.
 */
defined( 'ABSPATH' ) || exit;
?>
<div class="panel-wrap woocommerce">
	<input name="post_title" type="hidden" value="<?php echo empty( $quote_request_title ) ? esc_attr( get_post_type_object( $quote_request->get_type() )->labels->singular_name ) : esc_attr( $quote_request_title ); ?>" />
	<input name="post_status" type="hidden" value="<?php echo esc_attr( QTS_PREFIX . $quote_request->get_status() ); ?>" />
	<div id="order_data" class="panel woocommerce-order-data">
		<h2 class="woocommerce-order-data__heading">
			<?php
			printf(
					/* translators: 1: quote request number */
					esc_html__( 'Quote #%1$s details', 'quote-request-for-woocommerce' ), esc_html( $quote_request->get_order_number() )
			);
			?>
		</h2>
		<p class="woocommerce-order-data__meta order_number">
			<?php
			$meta_list = array();

			if ( $payment_method && 'other' !== $payment_method ) {
				$payment_method_string = sprintf(
						/* translators: %s: payment method */
						__( 'Payment via %s', 'quote-request-for-woocommerce' ), esc_html( isset( $payment_gateways[ $payment_method ] ) ? $payment_gateways[ $payment_method ]->get_title() : $payment_method )
				);

				$transaction_id = $quote_request->get_transaction_id();
				if ( $transaction_id ) {
					$url = $payment_gateways[ $payment_method ]->get_transaction_url( $quote_request );
					if ( isset( $payment_gateways[ $payment_method ] ) && $url ) {
						$payment_method_string .= ' (<a href="' . esc_url( $url ) . '" target="_blank">' . esc_html( $transaction_id ) . '</a>)';
					} else {
						$payment_method_string .= ' (' . esc_html( $transaction_id ) . ')';
					}
				}

				$meta_list[] = $payment_method_string;
			}

			if ( $quote_request->get_date_paid() ) {
				$meta_list[] = sprintf(
						/* translators: 1: date 2: time */
						__( 'Paid on %1$s @ %2$s', 'quote-request-for-woocommerce' ), wc_format_datetime( $quote_request->get_date_paid() ), wc_format_datetime( $quote_request->get_date_paid(), get_option( 'time_format' ) )
				);
			}

			$ip_address = $quote_request->get_customer_ip_address();
			if ( $ip_address ) {
				$meta_list[] = sprintf(
						/* translators: %s: IP address */
						__( 'Customer IP: %s', 'quote-request-for-woocommerce' ), '<span class="woocommerce-Order-customerIP">' . esc_html( $ip_address ) . '</span>'
				);
			}

			echo wp_kses_post( implode( '. ', $meta_list ) );
			?>
		</p>
		<div class="order_data_column_container">
			<div class="order_data_column" style="width: 30%">
				<?php if ( $quote_request->is_created_via( 'quote' ) ) : ?>
					<h3><?php esc_html_e( 'Basic Details', 'quote-request-for-woocommerce' ); ?></h3>

					<div class="form-field form-field-wide wc-customer-user-basic-details">
						<p><strong><?php esc_html_e( 'First Name', 'quote-request-for-woocommerce' ); ?>:</strong> <?php echo esc_html( $quote_request->get_meta( '_customer_first_name' ) ); ?></p>
						<p><strong><?php esc_html_e( 'Last Name', 'quote-request-for-woocommerce' ); ?>:</strong> <?php echo esc_html( $quote_request->get_meta( '_customer_last_name' ) ); ?></p>
					</div>
				<?php endif; ?>

				<h3><?php esc_html_e( 'General', 'quote-request-for-woocommerce' ); ?></h3>

				<p class="form-field form-field-wide">
					<label for="order_date"><?php esc_html_e( 'Date created:', 'quote-request-for-woocommerce' ); ?></label>
					<input type="text" class="date-picker" name="order_date" maxlength="10" value="<?php echo esc_attr( date_i18n( 'Y-m-d', _qts_get_time_based_on_timezone( strtotime( $quote_request->get_date_created() ) ) ) ); ?>" pattern="[0-9]{4}-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])" />@
					&lrm;
					<input type="number" class="hour" placeholder="<?php esc_attr_e( 'h', 'quote-request-for-woocommerce' ); ?>" name="order_date_hour" min="0" max="23" step="1" value="<?php echo esc_attr( date_i18n( 'H', _qts_get_time_based_on_timezone( strtotime( $quote_request->get_date_created() ) ) ) ); ?>" pattern="([01]?[0-9]{1}|2[0-3]{1})" />:
					<input type="number" class="minute" placeholder="<?php esc_attr_e( 'm', 'quote-request-for-woocommerce' ); ?>" name="order_date_minute" min="0" max="59" step="1" value="<?php echo esc_attr( date_i18n( 'i', _qts_get_time_based_on_timezone(strtotime( $quote_request->get_date_created() ) ) ) ); ?>" pattern="[0-5]{1}[0-9]{1}" />
					<input type="hidden" name="order_date_second" value="<?php echo esc_attr( date_i18n( 's', _qts_get_time_based_on_timezone( strtotime( $quote_request->get_date_created() ) ) ) ); ?>" />
				</p>

				<p class="form-field form-field-wide wc-order-status">
					<label for="order_status">
						<?php
						esc_html_e( 'Status:', 'quote-request-for-woocommerce' );
						if ( $quote_request->get_order_id( 'edit' ) ) {
							printf(
									/* translators: 1: edit order page url 2: order label  */
									'<a href="%1$s" target="_blank">%2$s</a>', esc_url( admin_url( "post.php?post={$quote_request->get_order_id()}&action=edit" ) ), esc_html__( 'Payment order &rarr;', 'quote-request-for-woocommerce' )
							);
						}
						?>
					</label>
					<select id="order_status" name="order_status" class="wc-enhanced-select">
						<?php
						$statuses = _qts_get_quote_request_statuses();
						foreach ( $statuses as $status_key => $status_name ) {
							if ( ! $quote_request->is_status_editable( $status_key ) ) {
								continue;
							}

							echo '<option value="' . esc_attr( $status_key ) . '" ' . selected( $status_key, QTS_PREFIX . $quote_request->get_status( 'edit' ), false ) . '>' . esc_html( $status_name ) . '</option>';
						}
						?>
					</select>
				</p>

				<?php
				if ( $quote_request->valid_to_expire() ) {
					$expiry_date = _qts_get_job_scheduled( 'quote_request', 'do_expire', $quote_request->get_id() );
					?>
					<p class="form-field form-field-wide">
						<label for="expiry_date"><?php esc_html_e( 'Expiry Date:', 'quote-request-for-woocommerce' ); ?></label>
						<input type="text" class="date-picker" name="expiry_date" maxlength="10" value="<?php echo esc_attr( date_i18n( 'Y-m-d', _qts_get_time_based_on_timezone( $expiry_date ) ) ); ?>" pattern="[0-9]{4}-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])" />@
						&lrm;
						<input type="number" class="hour" placeholder="<?php esc_attr_e( 'h', 'quote-request-for-woocommerce' ); ?>" name="expiry_date_hour" min="0" max="23" step="1" value="<?php echo esc_attr( date_i18n( 'H', _qts_get_time_based_on_timezone( $expiry_date ) ) ); ?>" pattern="([01]?[0-9]{1}|2[0-3]{1})" />:
						<input type="number" class="minute" placeholder="<?php esc_attr_e( 'm', 'quote-request-for-woocommerce' ); ?>" name="expiry_date_minute" min="0" max="59" step="1" value="<?php echo esc_attr( date_i18n( 'i', _qts_get_time_based_on_timezone( $expiry_date ) ) ); ?>" pattern="[0-5]{1}[0-9]{1}" />
						<input type="hidden" name="expiry_date_second" value="<?php echo esc_attr( date_i18n( 's', _qts_get_time_based_on_timezone( $expiry_date ) ) ); ?>" />
					</p>
				<?php } ?>

				<p class="form-field form-field-wide wc-customer-user">
					<label for="customer_user">
						<?php
						esc_html_e( 'Customer:', 'quote-request-for-woocommerce' );
						if ( $quote_request->get_user_id( 'edit' ) ) {
							$args = array(
								'post_status'    => 'all',
								'post_type'      => 'qts_quote_request',
								'_customer_user' => $quote_request->get_user_id( 'edit' ),
							);
							printf(
									/* translators: 1: view quote request url 2: view other quote requests  */
									'<a href="%s" target="_blank">%s</a>', esc_url( add_query_arg( $args, admin_url( 'edit.php' ) ) ), ' ' . esc_html__( 'View other quote requests &rarr;', 'quote-request-for-woocommerce' )
							);
							printf(
									/* translators: 1: profile url 2: profile  */
									'<a href="%s" target="_blank">%s</a>', esc_url( add_query_arg( 'user_id', $quote_request->get_user_id( 'edit' ), admin_url( 'user-edit.php' ) ) ), ' ' . esc_html__( 'Profile &rarr;', 'quote-request-for-woocommerce' )
							);
						}
						?>
					</label>
					<?php
					$user_string = '';
					$user_id     = '';
					if ( $quote_request->get_user_id() ) {
						$user_id     = absint( $quote_request->get_user_id() );
						$user        = get_user_by( 'id', $user_id );
						$user_string = sprintf(
								/* translators: 1: user display name 2: user ID 3: user email */
								esc_html__( '%1$s (#%2$s &ndash; %3$s)', 'quote-request-for-woocommerce' ), $user->display_name, absint( $user->ID ), $user->user_email
						);
					}
					?>
					<select class="wc-customer-search" id="customer_user" name="customer_user" data-placeholder="<?php esc_attr_e( 'Guest', 'quote-request-for-woocommerce' ); ?>" data-allow_clear="true">
						<option value="<?php echo esc_attr( $user_id ); ?>" selected="selected">
							<?php
							// htmlspecialchars to prevent XSS when rendered by selectWoo. 
							echo esc_html( htmlspecialchars( wp_kses_post( $user_string ) ) );
							?>
						</option>
					</select>
				</p>
				<?php
				/**
				 * After order details.
				 * 
				 * @since 1.0
				 */
				do_action( 'woocommerce_admin_order_data_after_order_details', $quote_request );
				?>
			</div>
			<div class="order_data_column" style="width: 30%">
				<h3>
					<?php esc_html_e( 'Billing', 'quote-request-for-woocommerce' ); ?>
					<a href="#" class="edit_address"><?php esc_html_e( 'Edit', 'quote-request-for-woocommerce' ); ?></a>
					<span>
						<a href="#" class="load_customer_billing" style="display:none;"><?php esc_html_e( 'Load billing address', 'quote-request-for-woocommerce' ); ?></a>
					</span>
				</h3>
				<div class="address">
					<?php
					// Display values.
					if ( $quote_request->get_formatted_billing_address() ) {
						echo '<p>' . wp_kses( $quote_request->get_formatted_billing_address(), array( 'br' => array() ) ) . '</p>';
					} else {
						echo '<p class="none_set"><strong>' . esc_html__( 'Address:', 'quote-request-for-woocommerce' ) . '</strong> ' . esc_html__( 'No billing address set.', 'quote-request-for-woocommerce' ) . '</p>';
					}

					foreach ( $billing_fields as $key => $field ) {
						if ( isset( $field[ 'show' ] ) && false === $field[ 'show' ] ) {
							continue;
						}

						$field_name = 'billing_' . $key;

						if ( isset( $field[ 'value' ] ) ) {
							$field_value = $field[ 'value' ];
						} elseif ( is_callable( array( $quote_request, 'get_' . $field_name ) ) ) {
							$field_value = $quote_request->{"get_$field_name"}( 'edit' );
						} else {
							$field_value = $quote_request->get_meta( '_' . $field_name );
						}

						if ( 'billing_phone' === $field_name ) {
							$field_value = wc_make_phone_clickable( $field_value );
						} else {
							$field_value = make_clickable( esc_html( $field_value ) );
						}

						if ( $field_value ) {
							echo '<p><strong>' . esc_html( $field[ 'label' ] ) . ':</strong> ' . wp_kses_post( $field_value ) . '</p>';
						}
					}

					if ( $quote_request->get_customer_note() ) {
						echo '<p class="order_note"><strong>' . esc_html__( 'Customer Provided Note:', 'quote-request-for-woocommerce' ) . '</strong> ' . nl2br( esc_html( $quote_request->get_customer_note() ) ) . '</p>';
					}
					?>
				</div>

				<div class="edit_address">
					<?php
					// Display form.
					foreach ( $billing_fields as $key => $field ) {
						if ( ! isset( $field[ 'type' ] ) ) {
							$field[ 'type' ] = 'text';
						}
						if ( ! isset( $field[ 'id' ] ) ) {
							$field[ 'id' ] = '_billing_' . $key;
						}

						$field_name = 'billing_' . $key;

						if ( ! isset( $field[ 'value' ] ) ) {
							if ( is_callable( array( $quote_request, 'get_' . $field_name ) ) ) {
								$field[ 'value' ] = $quote_request->{"get_$field_name"}( 'edit' );
							} else {
								$field[ 'value' ] = $quote_request->get_meta( '_' . $field_name );
							}
						}

						switch ( $field[ 'type' ] ) {
							case 'select':
								woocommerce_wp_select( $field );
								break;
							default:
								woocommerce_wp_text_input( $field );
								break;
						}
					}
					?>
					<p class="form-field form-field-wide">
						<label><?php esc_html_e( 'Payment method:', 'quote-request-for-woocommerce' ); ?></label>
						<select name="_payment_method" id="_payment_method" class="first">
							<option value=""><?php esc_html_e( 'N/A', 'quote-request-for-woocommerce' ); ?></option>
							<?php
							$found_method = false;

							foreach ( $payment_gateways as $gateway ) {
								if ( 'yes' === $gateway->enabled ) {
									echo '<option value="' . esc_attr( $gateway->id ) . '" ' . selected( $payment_method, $gateway->id, false ) . '>' . esc_html( $gateway->get_title() ) . '</option>';
									if ( $payment_method == $gateway->id ) {
										$found_method = true;
									}
								}
							}

							if ( ! $found_method && ! empty( $payment_method ) ) {
								echo '<option value="' . esc_attr( $payment_method ) . '" selected="selected">' . esc_html__( 'Other', 'quote-request-for-woocommerce' ) . '</option>';
							} else {
								echo '<option value="other">' . esc_html__( 'Other', 'quote-request-for-woocommerce' ) . '</option>';
							}
							?>
						</select>
					</p>
					<?php
					woocommerce_wp_text_input(
							array(
								'id'    => '_transaction_id',
								'label' => __( 'Transaction ID', 'quote-request-for-woocommerce' ),
								'value' => $quote_request->get_transaction_id( 'edit' ),
							)
					);
					?>
					<p class="form-field form-field-wide">
						<label for="excerpt"><?php esc_html_e( 'Customer Provided Note', 'quote-request-for-woocommerce' ); ?>:</label>
						<textarea rows="1" cols="40" name="excerpt" tabindex="6" id="excerpt" placeholder="<?php esc_attr_e( 'Customer notes about the quote request', 'quote-request-for-woocommerce' ); ?>"><?php echo wp_kses_post( $quote_request->get_customer_note() ); ?></textarea>
					</p>
				</div>
				<?php
				/**
				 * After billing address.
				 * 
				 * @since 1.0
				 */
				do_action( 'woocommerce_admin_order_data_after_billing_address', $quote_request );
				?>
			</div>
			<div class="order_data_column" style="width: 30%">
				<h3>
					<?php esc_html_e( 'Shipping', 'quote-request-for-woocommerce' ); ?>
					<a href="#" class="edit_address"><?php esc_html_e( 'Edit', 'quote-request-for-woocommerce' ); ?></a>
					<span>
						<a href="#" class="load_customer_shipping" style="display:none;"><?php esc_html_e( 'Load shipping address', 'quote-request-for-woocommerce' ); ?></a>
						<a href="#" class="billing-same-as-shipping" style="display:none;"><?php esc_html_e( 'Copy billing address', 'quote-request-for-woocommerce' ); ?></a>
					</span>
				</h3>
				<div class="address">
					<?php
					// Display values.
					if ( $quote_request->get_formatted_shipping_address() ) {
						echo '<p>' . wp_kses( $quote_request->get_formatted_shipping_address(), array( 'br' => array() ) ) . '</p>';
					} else {
						echo '<p class="none_set"><strong>' . esc_html__( 'Address:', 'quote-request-for-woocommerce' ) . '</strong> ' . esc_html__( 'No shipping address set.', 'quote-request-for-woocommerce' ) . '</p>';
					}

					if ( ! empty( $shipping_fields ) ) {
						foreach ( $shipping_fields as $key => $field ) {
							if ( isset( $field[ 'show' ] ) && false === $field[ 'show' ] ) {
								continue;
							}

							$field_name = 'shipping_' . $key;

							if ( is_callable( array( $quote_request, 'get_' . $field_name ) ) ) {
								$field_value = $quote_request->{"get_$field_name"}( 'edit' );
							} else {
								$field_value = $quote_request->get_meta( '_' . $field_name );
							}

							if ( $field_value ) {
								echo '<p><strong>' . esc_html( $field[ 'label' ] ) . ':</strong> ' . wp_kses_post( $field_value ) . '</p>';
							}
						}
					}
					?>
				</div>
				<div class="edit_address">
					<?php
					// Display form.
					if ( ! empty( $shipping_fields ) ) {
						foreach ( $shipping_fields as $key => $field ) {
							if ( ! isset( $field[ 'type' ] ) ) {
								$field[ 'type' ] = 'text';
							}
							if ( ! isset( $field[ 'id' ] ) ) {
								$field[ 'id' ] = '_shipping_' . $key;
							}

							$field_name = 'shipping_' . $key;

							if ( is_callable( array( $quote_request, 'get_' . $field_name ) ) ) {
								$field[ 'value' ] = $quote_request->{"get_$field_name"}( 'edit' );
							} else {
								$field[ 'value' ] = $quote_request->get_meta( '_' . $field_name );
							}

							switch ( $field[ 'type' ] ) {
								case 'select':
									woocommerce_wp_select( $field );
									break;
								default:
									woocommerce_wp_text_input( $field );
									break;
							}
						}
					}
					?>
				</div>

				<?php
				/**
				 * After shipping address.
				 * 
				 * @since 1.0
				 */
				do_action( 'woocommerce_admin_order_data_after_shipping_address', $quote_request );
				?>
			</div>
			<div class="order_data_column" style="width: 30%">
				<h3>
					<?php esc_html_e( 'Other Details', 'quote-request-for-woocommerce' ); ?>
				</h3>
				<div class="address">
					<?php
					// Display values.
					if ( empty( $quote_request->get_form_fields() ) ) {
						echo '<p class="none_set">' . esc_html__( 'No details found.', 'quote-request-for-woocommerce' ) . '</p>';
					} else {
						foreach ( $quote_request->get_form_fields() as $key => $field ) {
							if ( $field[ 'value' ] ) {
								if ( empty( $field[ 'label' ] ) ) {
									echo '<p>' . wp_kses_post( $field[ 'value' ] ) . '</p>';
								} else {
									echo '<p><strong>' . esc_html( $field[ 'label' ] ) . ':</strong> ' . ( is_array( $field[ 'value' ] ) ? wp_kses_post( implode( ', ', $field[ 'value' ] ) ) : wp_kses_post( $field[ 'value' ] ) ) . '</p>';
								}
							}
						}
					}
					?>
				</div>
			</div>
		</div>
		<div class="clear"></div>
	</div>
</div>
