<?php

defined( 'ABSPATH' ) || exit ;

/**
 * QTS Quote Shortcode class.
 * 
 * @class QTS_Shortcode_Quote
 * @package Classes
 */
class QTS_Shortcode_Quote {

	/**
	 * Quote page shortcode.
	 *
	 * @var string
	 */
	protected static $shortcode = 'qts_quote' ;

	/**
	 * Init QTS_Shortcode_Quote.
	 */
	public static function init() {
		add_shortcode( self::$shortcode, __CLASS__ . '::quote' ) ;
	}

	/**
	 * Shortcode Wrapper.
	 *
	 * @param string[] $function Callback function.
	 * @param array    $atts     Attributes. Default to empty array.
	 *
	 * @return string
	 */
	public static function shortcode_wrapper( $function, $atts = array() ) {
		ob_start() ;

		echo '<div class="quote-request-for-woocommerce">' ;
		call_user_func( $function, $atts ) ;
		echo '</div>' ;

		return ob_get_clean() ;
	}

	/**
	 * Quote page shortcode.
	 *
	 * @param array $atts Attributes.
	 * @return string
	 */
	public static function quote( $atts ) {
		return is_null( _qts()->quote ) ? '' : self::shortcode_wrapper( array( 'QTS_Shortcode_Quote', 'output' ), $atts ) ;
	}

	/**
	 * Output the Quote shortcode.
	 *
	 * @param array $atts Shortcode attributes.
	 */
	public static function output( $atts ) {
		_qts()->define( 'QTS_QUOTE', true ) ;
		_qts()->quote->check_quote_items() ;
		_qts()->quote->calculate_totals() ;

		// Print notices.
		wc_print_notices() ;

		if ( _qts()->quote->is_empty() ) {
			_qts_get_template( 'quote/quote-empty.php' ) ;
		} else {
			_qts_get_template( 'quote/quote.php' ) ;
		}
	}
}

QTS_Shortcode_Quote::init() ;
