<?php

use Automattic\WooCommerce\StoreApi\Schemas\V1\CartSchema;
use Automattic\WooCommerce\StoreApi\Schemas\V1\CartItemSchema;

/**
 * Store API integration class.
 *
 * @since 3.0.0
 * @class QTS_Store_API
 * @package Class
 */
class QTS_Store_API {

	/**
	 * Plugin identifier, unique to each plugin.
	 *
	 * @since 3.0.0
	 * @var string
	 */
	const IDENTIFIER = 'quote-request-for-woocommerce';

	/**
	 * Bootstraps the class and hooks required data.
	 *
	 * @since 3.0.0
	 */
	public static function init() {
		self::extend_store();
	}

	/**
	 * Register cart data handler.
	 *
	 * @since 3.0.0
	 */
	public static function extend_store() {
		if ( ! function_exists( 'woocommerce_store_api_register_endpoint_data' ) ) {
			return;
		}

		woocommerce_store_api_register_endpoint_data(
				array(
					'endpoint'        => CartItemSchema::IDENTIFIER,
					'namespace'       => self::IDENTIFIER,
					'data_callback'   => array( __CLASS__, 'extend_cart_item_data' ),
					'schema_callback' => array( __CLASS__, 'extend_cart_item_schema' ),
					'schema_type'     => ARRAY_A,
				)
		);

		woocommerce_store_api_register_endpoint_data(
				array(
					'endpoint'        => CartSchema::IDENTIFIER,
					'namespace'       => self::IDENTIFIER,
					'data_callback'   => array( __CLASS__, 'extend_cart_data' ),
					'schema_callback' => array( __CLASS__, 'extend_cart_schema' ),
					'schema_type'     => ARRAY_A,
				)
		);

		woocommerce_store_api_register_update_callback(
				array(
					'namespace' => self::IDENTIFIER,
					'callback'  => array( __CLASS__, 'handle_update_endpoint' ),
				)
		);
	}

	/**
	 * Register quote item into cart/items endpoint.
	 *
	 * @since 3.0.0
	 * @param  array $cart_item Current cart item data.
	 * @return array $item_data quote item data.
	 */
	public static function extend_cart_item_data( $cart_item ) {
		return array();
	}

	/**
	 * Adds extension data to cart route responses.
	 *
	 * @since 3.0.0
	 * @return array
	 */
	public static function extend_cart_data( $cart_item = null ) {
		$cart_data = array(
			'convert_to_quote_enabled' => false,
			'convert_to_quote_button'  => null,
			'back_to_cart_enabled'     => false,
			'back_to_cart_button'      => null,
		);

		if ( 'yes' === get_option( QTS_PREFIX . 'enable_convert_to_quote' ) ) {
			if ( 'yes' === WC()->session->get( QTS_PREFIX . 'converted_to_quote' ) ) {
				$cart_data['back_to_cart_enabled'] = true;
				$cart_data['back_to_cart_button']  = QTS_Cart::back_to_cart_button( false );
			} elseif ( ! QTS_Cart::asking_for_quote() ) {
				$cart_data['convert_to_quote_enabled'] = true;
				$cart_data['convert_to_quote_button']  = QTS_Cart::convert_to_quote_button( false );
			}
		}

		return $cart_data;
	}

	/**
	 * Handle our actions through StoreAPI.
	 *
	 * @since 3.0.0
	 * @param array $args
	 */
	public static function handle_update_endpoint( $args ) {
	}

	/**
	 * Quote product schema into cart/items endpoint.
	 *
	 * @since 3.0.0
	 * @return array Registered schema.
	 */
	public static function extend_cart_item_schema() {
		return array();
	}

	/**
	 * Register schema into cart endpoint.
	 *
	 * @since 3.0.0
	 * @return  array  Registered schema.
	 */
	public static function extend_cart_schema() {
		return array();
	}
}
