<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'QTS_Email_Customer_Quote_Acknowledged', false ) ) {

	/**
	 * Quote Acknowledged Email to Customer.
	 * 
	 * An email will be sent to the customer when the quote is submitted.
	 *
	 * @class QTS_Email_Customer_Quote_Acknowledged
	 * @package class
	 * @extends QTS_Abstract_Email
	 */
	class QTS_Email_Customer_Quote_Acknowledged extends QTS_Abstract_Email {

		/**
		 * Gets the user object.
		 * 
		 * @var WP_User
		 */
		public $user;

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->id             = QTS_PREFIX . 'customer_quote_acknowledged';
			$this->customer_email = true;
			$this->title          = __( 'Quote Acknowledged', 'quote-request-for-woocommerce' );
			$this->description    = __( 'Quote Acknowledged emails are sent to the customer when the quote is submitted', 'quote-request-for-woocommerce' );

			$this->template_html  = 'emails/customer-quote-acknowledged.php';
			$this->template_plain = 'emails/plain/customer-quote-acknowledged.php';

			$this->subject = __( '[{site_title}] - Quote Acknowledged', 'quote-request-for-woocommerce' );
			$this->heading = __( 'Quote Acknowledged.', 'quote-request-for-woocommerce' );

			// Triggers for this email.
			add_action( 'qts_quote_request_created_notification', array( $this, 'trigger' ) );

			// Call parent constructor
			parent::__construct();
		}

		/**
		 * Get content args.
		 *
		 * @return array
		 */
		public function get_content_args() {
			$content_args                    = parent::get_content_args();
			$content_args[ 'quote_request' ] = $this->object;
			$content_args[ 'user_nicename' ] = stripslashes( $this->user->user_nicename );
			$content_args[ 'user_login' ]    = stripslashes( $this->user->user_login );

			return $content_args;
		}

		/**
		 * Trigger the sending of this email.
		 *
		 * @param QTS_Quote_Request $quote_request
		 */
		public function trigger( $quote_request ) {
			if ( ! is_object( $quote_request ) ) {
				$quote_request_id = absint( $quote_request );
				$quote_request    = _qts_get_quote_request( $quote_request_id );
			}

			$this->object    = $quote_request;
			$this->user      = new WP_User( $quote_request->get_user_id() );
			$this->recipient = $quote_request->get_billing_email();

			$this->maybe_trigger();
		}
	}

}

return new QTS_Email_Customer_Quote_Acknowledged();
