<?php
/**
 * Quote Request details table shown in emails.
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/emails/email-quote-request-details.php.
 */
defined( 'ABSPATH' ) || exit;

$text_align           = is_rtl() ? 'right' : 'left';
$template             = $plain_text ? 'emails/plain/email-quote-request-items.php' : 'emails/email-quote-request-items.php';
$requested_price_type = $quote_request->get_requested_price_type();

/**
 * Add email before quote request table.
 * 
 * @since 1.0
 */
do_action( 'woocommerce_email_before_qtsquote_request_table', $quote_request, $sent_to_admin, $plain_text, $email );
?>
<h2>
	<?php
	if ( $sent_to_admin ) {
		$before = '<a class="link" href="' . esc_url( $quote_request->get_edit_order_url() ) . '">';
		$after  = '</a>';
	} else {
		$before = '';
		$after  = '';
	}
	/* translators: %s: Quote Request ID. */
	echo wp_kses_post( $before . sprintf( __( 'Quote Request #%s', 'quote-request-for-woocommerce' ) . $after . ' (<time datetime="%s">%s</time>)', $quote_request->get_order_number(), $quote_request->get_date_created()->format( 'c' ), wc_format_datetime( $quote_request->get_date_created() ) ) );
	?>
</h2>

<div style="margin-bottom: 40px;">
	<table class="td" cellspacing="0" cellpadding="6" style="width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;" border="1">
		<thead>
			<tr>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Product Name', 'quote-request-for-woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Original Price', 'quote-request-for-woocommerce' ); ?></th>

				<?php
				if ( 'percent' === $requested_price_type ) {
					?>
					<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Requested Price Percentage', 'quote-request-for-woocommerce' ); ?></th>
					<?php
				} else if ( 'percent-discount' === $requested_price_type ) {
					?>
					<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Requested Discount Percentage', 'quote-request-for-woocommerce' ); ?></th>
					<?php
				} else {
					?>
					<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Requested Price', 'quote-request-for-woocommerce' ); ?></th>
					<?php
				}
				?>

				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Offered Price', 'quote-request-for-woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Requested Quantity', 'quote-request-for-woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Total', 'quote-request-for-woocommerce' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			/**
			 * Get email quote request items args.
			 * 
			 * @since 1.0
			 */
			_qts_get_template( $template, apply_filters( 'woocommerce_email_qtsquote_request_items_args', array(
				'quote_request'    => $quote_request,
				'items'            => $quote_request->get_items( 'line_item' ),
				'show_sku'         => $sent_to_admin,
				'show_product_url' => true,
				'show_image'       => false,
				'image_size'       => array( 32, 32 ),
				'plain_text'       => $plain_text,
				'sent_to_admin'    => $sent_to_admin,
					) )
			);
			?>
		</tbody>
		<tfoot>
			<?php
			if ( $quote_request->is_created_via( 'checkout' ) ) {
				$item_totals = $quote_request->get_order_item_totals();

				$i = 0;
				foreach ( $item_totals as $total ) {
					$i++;
					?>
					<tr>
						<th class="td" scope="row" colspan="5" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?php echo wp_kses_post( $total[ 'label' ] ); ?></th>
						<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?php echo wp_kses_post( $total[ 'value' ] ); ?></td>
					</tr>
					<?php
				}
			}
			?>
		</tfoot>
	</table>
</div>

<?php
/**
 * Add email after quote request table.
 * 
 * @since 1.0
 */
do_action( 'woocommerce_email_after_qtsquote_request_table', $quote_request, $sent_to_admin, $plain_text, $email );
?>
