<?php
/**
 * Mini Quote.
 *
 * This template can be overridden by copying it to yourtheme/quote-request-for-woocommerce/quote/mini-quote.php.
 */
defined( 'ABSPATH' ) || exit;

$quote_page_url = get_page_link( get_option( 'woocommerce_qts_quote_page_id', true ) );
?>
<li class="qts-mini-quote-menu-item menu-item menu-item-type-post_type menu-item-object-page current-menu-item current_page_item">
	<a class="qts-quote-contents" href="<?php echo esc_url( $quote_page_url ); ?>" title="<?php esc_attr_e( 'View Quote', 'quote-request-for-woocommerce' ); ?>">
		<span class="count">
			<?php
			/* translators: 1: Quote items count */
			printf( esc_html__( '%s items', 'quote-request-for-woocommerce' ), esc_attr( _qts()->quote->get_quote_contents_count() ) );
			?>
		</span>
		<span class="dashicons dashicons-media-spreadsheet"></span>
	</a>
	<?php
	if ( ! _qts_is_quote() ) :
		/**
		 * Before Mini Quote
		 *
		 * @since 2.7.0
		 */
		do_action( 'qts_before_mini_quote' );
		?>
		<div class="qts-mini-quote">
			<?php if ( ! _qts()->quote->is_empty() ) : ?>
				<ul class="quote_list product_list_widget <?php echo esc_attr( $args[ 'list_class' ] ); ?>">
					<?php
					/**
					 * Before Mini Quote Content
					 *
					 * @since 2.7.0
					 */
					do_action( 'qts_before_mini_quote_contents' );

					foreach ( _qts()->quote->get_quote() as $quote_item_key => $quote_item ) :
						/**
						 * Mini Quote Item Product
						 *
						 * @since 2.7.0
						 */
						$_product   = apply_filters( 'qts_mini_quote_item_product', $quote_item[ 'data' ], $quote_item, $quote_item_key );
						/**
						 * Mini Quote Item Product ID
						 *
						 * @since 2.7.0
						 */
						$product_id = apply_filters( 'qts_mini_quote_item_product_id', $quote_item[ 'product_id' ], $quote_item, $quote_item_key );

						/**
						 * Mini Quote Item Visible Check
						 *
						 * @since 2.7.0
						 */
						if ( $_product && $_product->exists() && $quote_item[ 'quantity' ] > 0 && apply_filters( 'qts_widget_quote_item_visible', true, $quote_item, $quote_item_key ) ) :
							/**
							 * Mini Quote Item Name
							 *
							 * @since 2.7.0
							 */
							$product_name      = apply_filters( 'qts_quote_item_name', $_product->get_name(), $quote_item, $quote_item_key );
							/**
							 * Mini Quote Item Thumbnail
							 *
							 * @since 2.7.0
							 */
							$thumbnail         = apply_filters( 'qts_quote_item_thumbnail', $_product->get_image(), $quote_item, $quote_item_key );
							/**
							 * Mini Quote Item Price
							 *
							 * @since 2.7.0
							 */
							$product_price     = apply_filters( 'qts_quote_item_price', wc_price( _qts()->quote->get_product_price( $quote_item_key ) ), $quote_item, $quote_item_key );
							/**
							 * Mini Quote Item Link
							 *
							 * @since 2.7.0
							 */
							$product_permalink = apply_filters( 'qts_quote_item_permalink', $_product->is_visible() ? $_product->get_permalink( $quote_item ) : '', $quote_item, $quote_item_key );
							?>
							<li class="qts-mini-quote-item
							<?php
							/**
							 * Mini Quote Item Classes
							 *
							 * @since 2.7.0
							 */
							echo esc_attr( apply_filters( 'qts_mini_quote_item_class', 'mini_quote_item', $quote_item, $quote_item_key ) );
							?>
								">
									<?php
									printf(
											'<a href="%s" class="qts-remove" aria-label="%s" data-product_id="%s" data-quote_item_key="%s" data-product_sku="%s">&times;</a>',
											esc_url( _qts_get_quote_remove_url( $quote_item_key ) ),
											esc_html__( 'Remove this item', 'quote-request-for-woocommerce' ),
											esc_attr( $quote_item[ 'product_id' ] ),
											esc_attr( $quote_item_key ),
											esc_attr( $_product->get_sku() )
									);

									if ( empty( $product_permalink ) ) :
										echo wp_kses_post( $thumbnail ) . wp_kses_post( $product_name );
									else :
										echo '<a href="' . esc_url( $product_permalink ) . '">' . wp_kses_post( $thumbnail ) . wp_kses_post( $product_name ) . '</a>';
									endif;

									echo wp_kses_post( _qts_get_formatted_quote_item_data( $quote_item ) );
									/**
									 * Quote item Quantity
									 *
									 * @since 2.7.0
									 */
									echo wp_kses_post( apply_filters( 'qts_widget_quote_item_quantity', '<span class="quantity">' . sprintf( '%s &times; %s', $quote_item[ 'quantity' ], $product_price ) . '</span>', $quote_item, $quote_item_key ) );
									?>
							</li>
							<?php
						endif;
					endforeach;

					/**
					 * After Mini Quote Content
					 *
					 * @since 2.7.0
					 */
					do_action( 'qts_after_mini_quote_contents' );
					?>
				</ul>

				<p class="qts-mini-quote__total total">
					<?php
					/**
					 * Hook: qts_widget_quote_total.
					 *
					 * @since 2.7.0
					 */
					do_action( 'qts_widget_quote_total' );
					?>
				</p>

				<?php
				/**
				 * Before Widget Quote Buttons
				 *
				 * @since 2.7.0
				 */
				do_action( 'qts_widget_quote_before_buttons' );
				?>
				<p class="qts-mini-quote__buttons buttons">
					<?php
					/**
					 * Widget Quote Buttons
					 *
					 * @since 2.7.0
					 */
					do_action( 'qts_widget_quote_buttons' );
					?>
				</p>
				<?php
				/**
				 * After Widget Quote Buttons
				 *
				 * @since 2.7.0
				 */
				do_action( 'qts_widget_quote_after_buttons' );
				?>

			<?php else : ?> 
				<p class="qts-mini-cart__empty-message"><?php esc_html_e( 'No products in the quote basket.', 'quote-request-for-woocommerce' ); ?></p>
			<?php endif; ?>
		</div>
		<?php
		/**
		 * After Mini Quote.
		 *
		 * @since 2.7.0
		 */
		do_action( 'qts_after_mini_quote' );
	endif;
	?>
</li>
<?php
